/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzBO;
import asposewobfuscated.zzBR;
import asposewobfuscated.zzGR;
import asposewobfuscated.zzN7;
import asposewobfuscated.zzTT;
import asposewobfuscated.zzZ;
import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.zz4D;
import java.io.EOFException;
import java.io.InputStream;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static zzGR zzZnS = new zzGR();
    private static zzGR zzZnR = new zzGR();
    private static zzGR zzZnQ = new zzGR();
    private static zzGR zzZnP = new zzGR();
    private static zzGR zzZnO = new zzGR();
    private static zzGR zzZnN = new zzGR();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzBR zzBR2;
        zzN7.zzP(fileName, "fileName");
        zzBR2 = zzZ.zzU((String)((Object)zzBR2));
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zz7(zzBR2);
            return fileFormatInfo;
        }
        finally {
            ((zzBO)zzBR2).close();
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zz7(zzZ.zzZ(stream));
    }

    static FileFormatInfo zz7(zzBO zzBO2) throws Exception {
        if (zzBO2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zz4D zz4D2 = new zz4D();
            return zz4D2.zz9(zzBO2);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZ(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzMl(zzTT.zzo(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzMp(zzTT.zzo(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string = zzTT.zzYr(FileFormatUtil.zzMn(loadFormat));
        if (zzN7.zzZU(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzMl(FileFormatUtil.zzMm(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzMp(FileFormatUtil.zzMn(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzTT.zzYr(FileFormatUtil.zzMm(saveFormat));
        if (zzN7.zzZU(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        String string;
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzMp(zzTT.zzn(string));
    }

    public static String imageTypeToExtension(int imageType) {
        int n;
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        Object object = zzZnQ.get(n);
        return "." + zzTT.zzYr(object == null ? 0 : (Integer)object);
    }

    static Exception zzZ(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzMq(int n) {
        return zzTT.toString(FileFormatUtil.zzMm(n));
    }

    static int zzMp(int n) {
        Object object = zzZnO.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    static int zzMo(int n) {
        Object object = zzZnN.get(n);
        if (object != null) {
            return (Integer)object;
        }
        return 1;
    }

    private static int zzMn(int n) {
        Object object = zzZnS.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    private static int zzMm(int n) {
        Object object = zzZnR.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    private static int zzMl(int n) {
        Object object = zzZnP.get(n);
        if (object == null) {
            return 255;
        }
        return (Integer)object;
    }

    static {
        Object[] objectArray = new Object[]{11, 10, 10, null, 11, null, 0, null, 12, 11, 11, null, 13, 20, 20, null, 13, null, 254, null, 14, 21, 21, null, 15, 22, 22, null, 16, 23, 23, null, 18, 24, 24, null, 19, 25, 25, null, 20, 26, 26, null, 21, 27, 27, null, 24, 30, 30, null, 17, 31, 31, null, 25, 50, 50, null, 26, 45, null, null, 27, 51, 51, null, 22, 60, 60, null, 23, 61, 61, null, 30, 40, null, null, 38, 47, null, null, 31, 41, null, null, 32, 46, null, null, 35, 42, null, null, 33, 43, null, null, 34, 44, null, null, 28, 52, null, null, 29, 70, 62, null, 36, 71, null, null, 8, 100, null, null, 6, 101, null, 6, 7, 102, null, 7, 5, 104, null, 5, 4, null, null, 4, 3, null, null, 3, 37, 72, null, null, 2, 103, null, 2};
        for (int i = 0; i < 148; i += 4) {
            Object object = objectArray[i];
            Object object2 = objectArray[i + 1];
            Object object3 = objectArray[i + 2];
            Object object4 = objectArray[i + 3];
            if (object2 != null) {
                zzZnO.add((Integer)object, object2);
                zzZnR.add((Integer)object2, object);
            }
            if (object3 != null) {
                if (!zzZnP.contains((Integer)object)) {
                    zzZnP.add((Integer)object, object3);
                }
                zzZnS.add((Integer)object3, object);
            }
            if (object4 == null) continue;
            zzZnN.add((Integer)object, object4);
            zzZnQ.add((Integer)object4, object);
        }
    }
}

