/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.testutils;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.SimpleTextExtractionStrategy;
import com.itextpdf.text.pdf.parser.TaggedPdfReaderTool;
import com.itextpdf.text.pdf.parser.TextExtractionStrategy;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.itextpdf.text.xml.XMLUtil;
import com.itextpdf.xmp.XMPException;
import com.itextpdf.xmp.XMPMeta;
import com.itextpdf.xmp.XMPMetaFactory;
import com.itextpdf.xmp.XMPUtils;
import com.itextpdf.xmp.options.SerializeOptions;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareTool {
    private String gsExec;
    private String compareExec;
    private final String gsParams = " -dNOPAUSE -dBATCH -sDEVICE=png16m -r150 -sOutputFile=<outputfile> <inputfile>";
    private final String compareParams = " <image1> <image2> <difference>";
    private static final String cannotOpenTargetDirectory = "Cannot open target directory for <filename>.";
    private static final String gsFailed = "GhostScript failed for <filename>.";
    private static final String unexpectedNumberOfPages = "Unexpected number of pages for <filename>.";
    private static final String differentPages = "File <filename> differs on page <pagenumber>.";
    private static final String undefinedGsPath = "Path to GhostScript is not specified. Please use -DgsExec=<path_to_ghostscript> (e.g. -DgsExec=\"C:/Program Files/gs/gs8.64/bin/gswin32c.exe\")";
    private static final String ignoredAreasPrefix = "ignored_areas_";
    private String cmpPdf;
    private String cmpPdfName;
    private String cmpImage;
    private String outPdf;
    private String outPdfName;
    private String outImage;

    public CompareTool(String outPdf, String cmpPdf) {
        this.init(outPdf, cmpPdf);
        this.gsExec = System.getProperty("gsExec");
        this.compareExec = System.getProperty("compareExec");
    }

    public String compare(String outPath, String differenceImagePrefix) throws IOException, InterruptedException, DocumentException {
        return this.compare(outPath, differenceImagePrefix, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String compare(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws IOException, InterruptedException, DocumentException {
        int cnt;
        String line;
        File[] cmpImageFiles;
        File[] imageFiles;
        File targetDir;
        if (this.gsExec == null) {
            return undefinedGsPath;
        }
        if (!new File(this.gsExec).exists()) {
            return new File(this.gsExec).getAbsolutePath() + " does not exist";
        }
        if (!outPath.endsWith("/")) {
            outPath = outPath + "/";
        }
        if (!(targetDir = new File(outPath)).exists()) {
            targetDir.mkdir();
        } else {
            for (File file : imageFiles = targetDir.listFiles(new PngFileFilter())) {
                file.delete();
            }
            for (File file : cmpImageFiles = targetDir.listFiles(new CmpPngFileFilter())) {
                file.delete();
            }
        }
        File diffFile = new File(outPath + differenceImagePrefix);
        if (diffFile.exists()) {
            diffFile.delete();
        }
        if (ignoredAreas != null && !ignoredAreas.isEmpty()) {
            PdfReader cmpReader = new PdfReader(this.cmpPdf);
            PdfReader outReader = new PdfReader(this.outPdf);
            PdfStamper outStamper = new PdfStamper(outReader, new FileOutputStream(outPath + ignoredAreasPrefix + this.outPdfName));
            PdfStamper cmpStamper = new PdfStamper(cmpReader, new FileOutputStream(outPath + ignoredAreasPrefix + this.cmpPdfName));
            for (Map.Entry<Integer, List<Rectangle>> entry : ignoredAreas.entrySet()) {
                int pageNumber = entry.getKey();
                List<Rectangle> rectangles = entry.getValue();
                if (rectangles == null || rectangles.isEmpty()) continue;
                PdfContentByte outCB = outStamper.getOverContent(pageNumber);
                PdfContentByte cmpCB = cmpStamper.getOverContent(pageNumber);
                for (Rectangle rect : rectangles) {
                    rect.setBackgroundColor(BaseColor.BLACK);
                    outCB.rectangle(rect);
                    cmpCB.rectangle(rect);
                }
            }
            outStamper.close();
            cmpStamper.close();
            outReader.close();
            cmpReader.close();
            this.init(outPath + ignoredAreasPrefix + this.outPdfName, outPath + ignoredAreasPrefix + this.cmpPdfName);
        }
        if (!targetDir.exists()) return cannotOpenTargetDirectory.replace("<filename>", this.outPdf);
        String gsParams = this.gsParams.replace("<outputfile>", outPath + this.cmpImage).replace("<inputfile>", this.cmpPdf);
        Process p = Runtime.getRuntime().exec(this.gsExec + gsParams);
        BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = bri.readLine()) != null) {
            System.out.println(line);
        }
        bri.close();
        while ((line = bre.readLine()) != null) {
            System.out.println(line);
        }
        bre.close();
        if (p.waitFor() != 0) return gsFailed.replace("<filename>", this.cmpPdf);
        gsParams = this.gsParams.replace("<outputfile>", outPath + this.outImage).replace("<inputfile>", this.outPdf);
        p = Runtime.getRuntime().exec(this.gsExec + gsParams);
        bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
        bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = bri.readLine()) != null) {
            System.out.println(line);
        }
        bri.close();
        while ((line = bre.readLine()) != null) {
            System.out.println(line);
        }
        bre.close();
        int exitValue = p.waitFor();
        if (exitValue != 0) return gsFailed.replace("<filename>", this.outPdf);
        imageFiles = targetDir.listFiles(new PngFileFilter());
        cmpImageFiles = targetDir.listFiles(new CmpPngFileFilter());
        boolean bUnexpectedNumberOfPages = false;
        if (imageFiles.length != cmpImageFiles.length) {
            bUnexpectedNumberOfPages = true;
        }
        if ((cnt = Math.min(imageFiles.length, cmpImageFiles.length)) < 1) {
            return "No files for comparing!!!\nThe result or sample pdf file is not processed by GhostScript.";
        }
        Arrays.sort(imageFiles, new ImageNameComparator());
        Arrays.sort(cmpImageFiles, new ImageNameComparator());
        String differentPagesFail = null;
        for (int i = 0; i < cnt; ++i) {
            System.out.print("Comparing page " + Integer.toString(i + 1) + " (" + imageFiles[i].getAbsolutePath() + ")...");
            FileInputStream is1 = new FileInputStream(imageFiles[i]);
            FileInputStream is2 = new FileInputStream(cmpImageFiles[i]);
            boolean cmpResult = this.compareStreams(is1, is2);
            is1.close();
            is2.close();
            if (!cmpResult) {
                if (new File(this.compareExec).exists()) {
                    String compareParams = this.compareParams.replace("<image1>", imageFiles[i].getAbsolutePath()).replace("<image2>", cmpImageFiles[i].getAbsolutePath()).replace("<difference>", outPath + differenceImagePrefix + Integer.toString(i + 1) + ".png");
                    p = Runtime.getRuntime().exec(this.compareExec + compareParams);
                    bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    while ((line = bre.readLine()) != null) {
                        System.out.println(line);
                    }
                    bre.close();
                    int cmpExitValue = p.waitFor();
                    if (cmpExitValue == 0) {
                        if (differentPagesFail == null) {
                            differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i + 1));
                            differentPagesFail = differentPagesFail + "\nPlease, examine " + outPath + differenceImagePrefix + Integer.toString(i + 1) + ".png for more details.";
                        } else {
                            differentPagesFail = "File " + this.outPdf + " differs.\nPlease, examine difference images for more details.";
                        }
                    } else {
                        differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i + 1));
                    }
                } else {
                    differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i + 1));
                    differentPagesFail = differentPagesFail + "\nYou can optionally specify path to ImageMagick compare tool (e.g. -DcompareExec=\"C:/Program Files/ImageMagick-6.5.4-2/compare.exe\") to visualize differences.";
                    break;
                }
                System.out.println(differentPagesFail);
                continue;
            }
            System.out.println("done.");
        }
        if (differentPagesFail != null) {
            return differentPagesFail;
        }
        if (!bUnexpectedNumberOfPages) return null;
        return unexpectedNumberOfPages.replace("<filename>", this.outPdf);
    }

    public String compare(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws IOException, InterruptedException, DocumentException {
        this.init(outPdf, cmpPdf);
        return this.compare(outPath, differenceImagePrefix, ignoredAreas);
    }

    public String compare(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix) throws IOException, InterruptedException, DocumentException {
        return this.compare(outPdf, cmpPdf, outPath, differenceImagePrefix, null);
    }

    public String compareXmp() {
        return this.compareXmp(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compareXmp(boolean ignoreDateAndProducerProperties) {
        PdfReader cmpReader = null;
        PdfReader outReader = null;
        try {
            cmpReader = new PdfReader(this.cmpPdf);
            outReader = new PdfReader(this.outPdf);
            byte[] cmpBytes = cmpReader.getMetadata();
            byte[] outBytes = outReader.getMetadata();
            if (ignoreDateAndProducerProperties) {
                XMPMeta xmpMeta = XMPMetaFactory.parseFromBuffer(cmpBytes);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "CreateDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "ModifyDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "MetadataDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/pdf/1.3/", "Producer", true, true);
                cmpBytes = XMPMetaFactory.serializeToBuffer(xmpMeta, new SerializeOptions(8192));
                xmpMeta = XMPMetaFactory.parseFromBuffer(outBytes);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "CreateDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "ModifyDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "MetadataDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/pdf/1.3/", "Producer", true, true);
                outBytes = XMPMetaFactory.serializeToBuffer(xmpMeta, new SerializeOptions(8192));
            }
            if (!this.compareXmls(cmpBytes, outBytes)) {
                String string = "The XMP packages different!!!";
                return string;
            }
        }
        catch (XMPException xmpExc) {
            String string = "XMP parsing failure!!!";
            return string;
        }
        catch (IOException ioExc) {
            String string = "XMP parsing failure!!!";
            return string;
        }
        catch (ParserConfigurationException parseExc) {
            String string = "XMP parsing failure!!!";
            return string;
        }
        catch (SAXException parseExc) {
            String string = "XMP parsing failure!!!";
            return string;
        }
        finally {
            if (cmpReader != null) {
                cmpReader.close();
            }
            if (outReader != null) {
                outReader.close();
            }
        }
        return null;
    }

    public boolean compareXmls(byte[] xml1, byte[] xml2) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc1 = db.parse(new ByteArrayInputStream(xml1));
        doc1.normalizeDocument();
        Document doc2 = db.parse(new ByteArrayInputStream(xml2));
        doc2.normalizeDocument();
        return doc2.isEqualNode(doc1);
    }

    public String compareDocumentInfo(String outPdf, String cmpPdf) throws IOException {
        System.out.println("Comparing document info...");
        String message = null;
        PdfReader outReader = new PdfReader(outPdf);
        PdfReader cmpReader = new PdfReader(cmpPdf);
        String[] cmpInfo = this.convertInfo(cmpReader.getInfo());
        String[] outInfo = this.convertInfo(outReader.getInfo());
        for (int i = 0; i < cmpInfo.length; ++i) {
            if (cmpInfo[i].equals(outInfo[i])) continue;
            message = "Document info fail";
            break;
        }
        outReader.close();
        cmpReader.close();
        return message;
    }

    public String compareLinks(String outPdf, String cmpPdf) throws IOException {
        System.out.println("Comparing link annotations...");
        String message = null;
        PdfReader outReader = new PdfReader(outPdf);
        PdfReader cmpReader = new PdfReader(cmpPdf);
        block0: for (int i = 0; i < outReader.getNumberOfPages() && i < cmpReader.getNumberOfPages(); ++i) {
            ArrayList<PdfAnnotation.PdfImportedLink> outLinks = outReader.getLinks(i + 1);
            ArrayList<PdfAnnotation.PdfImportedLink> cmpLinks = cmpReader.getLinks(i + 1);
            if (cmpLinks.size() != outLinks.size()) {
                message = String.format("Different number of links on page %d.", i + 1);
                break;
            }
            for (int j = 0; j < cmpLinks.size(); ++j) {
                if (((PdfAnnotation.PdfImportedLink)cmpLinks.get(j)).toString().equals(((PdfAnnotation.PdfImportedLink)outLinks.get(j)).toString())) continue;
                message = String.format("Different links on page %d.\n%s\n%s", i + 1, ((PdfAnnotation.PdfImportedLink)cmpLinks.get(j)).toString(), ((PdfAnnotation.PdfImportedLink)outLinks.get(j)).toString());
                continue block0;
            }
        }
        outReader.close();
        cmpReader.close();
        return message;
    }

    public String compareTagStructures(String outPdf, String cmpPdf) throws IOException, ParserConfigurationException, SAXException {
        System.out.println("Comparing tag structures...");
        String outXml = outPdf.replace(".pdf", ".xml");
        String cmpXml = cmpPdf.replace(".pdf", ".xml");
        String error = null;
        PdfReader reader = new PdfReader(outPdf);
        FileOutputStream xmlOut1 = new FileOutputStream(outXml);
        new CmpTaggedPdfReaderTool().convertToXml(reader, xmlOut1);
        reader.close();
        reader = new PdfReader(cmpPdf);
        FileOutputStream xmlOut2 = new FileOutputStream(cmpXml);
        new CmpTaggedPdfReaderTool().convertToXml(reader, xmlOut2);
        reader.close();
        if (!this.compareXmls(outXml, cmpXml)) {
            error = "The tag structures are different.";
        }
        xmlOut1.close();
        xmlOut2.close();
        return error;
    }

    private String[] convertInfo(HashMap<String, String> info) {
        String[] convertedInfo = new String[]{"", "", "", ""};
        for (Map.Entry<String, String> entry : info.entrySet()) {
            if ("title".equalsIgnoreCase(entry.getKey())) {
                convertedInfo[0] = entry.getValue();
                continue;
            }
            if ("author".equalsIgnoreCase(entry.getKey())) {
                convertedInfo[1] = entry.getValue();
                continue;
            }
            if ("subject".equalsIgnoreCase(entry.getKey())) {
                convertedInfo[2] = entry.getValue();
                continue;
            }
            if (!"keywords".equalsIgnoreCase(entry.getKey())) continue;
            convertedInfo[3] = entry.getValue();
        }
        return convertedInfo;
    }

    public boolean compareXmls(String xml1, String xml2) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc1 = db.parse(new File(xml1));
        doc1.normalizeDocument();
        Document doc2 = db.parse(new File(xml2));
        doc2.normalizeDocument();
        return doc2.isEqualNode(doc1);
    }

    private void init(String outPdf, String cmpPdf) {
        this.outPdf = outPdf;
        this.cmpPdf = cmpPdf;
        this.outPdfName = new File(outPdf).getName();
        this.cmpPdfName = new File(cmpPdf).getName();
        this.outImage = this.outPdfName + "-%03d.png";
        this.cmpImage = this.cmpPdfName.startsWith("cmp_") ? this.cmpPdfName + "-%03d.png" : "cmp_" + this.cmpPdfName + "-%03d.png";
    }

    private boolean compareStreams(InputStream is1, InputStream is2) throws IOException {
        int len1;
        byte[] buffer1 = new byte[65536];
        byte[] buffer2 = new byte[65536];
        do {
            int len2;
            if ((len1 = is1.read(buffer1)) != (len2 = is2.read(buffer2))) {
                return false;
            }
            if (Arrays.equals(buffer1, buffer2)) continue;
            return false;
        } while (len1 != -1);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CmpMarkedContentRenderFilter
    implements RenderListener {
        Map<Integer, TextExtractionStrategy> tagsByMcid = new HashMap<Integer, TextExtractionStrategy>();

        CmpMarkedContentRenderFilter() {
        }

        public Map<Integer, String> getParsedTagContent() {
            HashMap<Integer, String> content = new HashMap<Integer, String>();
            for (int id : this.tagsByMcid.keySet()) {
                content.put(id, this.tagsByMcid.get(id).getResultantText());
            }
            return content;
        }

        @Override
        public void beginTextBlock() {
            for (int id : this.tagsByMcid.keySet()) {
                this.tagsByMcid.get(id).beginTextBlock();
            }
        }

        @Override
        public void renderText(TextRenderInfo renderInfo) {
            Integer mcid = renderInfo.getMcid();
            if (mcid != null && this.tagsByMcid.containsKey(mcid)) {
                this.tagsByMcid.get(mcid).renderText(renderInfo);
            } else if (mcid != null) {
                this.tagsByMcid.put(mcid, new SimpleTextExtractionStrategy());
                this.tagsByMcid.get(mcid).renderText(renderInfo);
            }
        }

        @Override
        public void endTextBlock() {
            for (int id : this.tagsByMcid.keySet()) {
                this.tagsByMcid.get(id).endTextBlock();
            }
        }

        @Override
        public void renderImage(ImageRenderInfo renderInfo) {
        }
    }

    class CmpTaggedPdfReaderTool
    extends TaggedPdfReaderTool {
        Map<PdfDictionary, Map<Integer, String>> parsedTags = new HashMap<PdfDictionary, Map<Integer, String>>();

        CmpTaggedPdfReaderTool() {
        }

        public void parseTag(String tag, PdfObject object, PdfDictionary page) throws IOException {
            if (object instanceof PdfNumber) {
                if (!this.parsedTags.containsKey(page)) {
                    CmpMarkedContentRenderFilter listener = new CmpMarkedContentRenderFilter();
                    PdfContentStreamProcessor processor = new PdfContentStreamProcessor(listener);
                    processor.processContent(PdfReader.getPageContent(page), page.getAsDict(PdfName.RESOURCES));
                    this.parsedTags.put(page, listener.getParsedTagContent());
                }
                String tagContent = "";
                if (this.parsedTags.get(page).containsKey(((PdfNumber)object).intValue())) {
                    tagContent = this.parsedTags.get(page).get(((PdfNumber)object).intValue());
                }
                this.out.print(XMLUtil.escapeXML(tagContent, true));
            } else {
                super.parseTag(tag, object, page);
            }
        }

        public void inspectChildDictionary(PdfDictionary k) throws IOException {
            this.inspectChildDictionary(k, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ImageNameComparator
    implements Comparator<File> {
        ImageNameComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            String f1Name = f1.getAbsolutePath();
            String f2Name = f2.getAbsolutePath();
            return f1Name.compareTo(f2Name);
        }
    }

    class CmpPngFileFilter
    implements FileFilter {
        CmpPngFileFilter() {
        }

        public boolean accept(File pathname) {
            String ap = pathname.getAbsolutePath();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.contains("cmp_");
            return b1 && b2 && ap.contains(CompareTool.this.cmpPdfName);
        }
    }

    class PngFileFilter
    implements FileFilter {
        PngFileFilter() {
        }

        public boolean accept(File pathname) {
            String ap = pathname.getAbsolutePath();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.contains("cmp_");
            return b1 && !b2 && ap.contains(CompareTool.this.outPdfName);
        }
    }
}

