$(function() {
    $('#loading').modal('show');
  fetchJSON("/api/tag/hot?page=0&size=50", {}, "get", function(ret) {
    if (ret.code === 0) {
      if (ret.data.length > 0) {
        $("#hotTag").empty();
        for (var i = 0; i < ret.data.length; i++) {
          $("#hotTag").append(
            $("<a>", {
              href: "list_index.html?q=" + ret.data[i].keyword,
              text: ret.data[i].keyword,
              class: "tagItem"
            })
          );
        }
      }
    } else {
      console.log(ret.msg);
    }
      $('#loading').modal('hide');
  });

  $("#search").on("click", function(e) {
    e.preventDefault();
    submitSearch($("#keyword"));
  });
  $("#keyword").on("keyup", function(e) {
    e.preventDefault();
    if (e.keyCode === 13) submitSearch($("#keyword"));
  });

  function submitSearch(control) {
    if (control.val().trim() === "") {
      control.focus();
      return;
    }
    var keylist = encodeURIComponent(control.val().trim());
    window.location.href = "list_index.html?q=" + keylist;
  }
});
