$(function() {
  fetchJSON("api/config/getSD", {}, "post", function(ret) {
    if (ret.code === 0) {
      $("#submitDirectory").val(ret.data[0].confValue);
    } else {
      console.log(ret.msg);
    }
  });
  fetchJSON("api/config/getRD", {}, "post", function(ret) {
    if (ret.code === 0) {
      $("#resourceDirectory").val(ret.data[0].confValue);
    } else {
      console.log(ret.msg);
    }
  });
  fetchJSON("api/config/getWD", {}, "post", function(ret) {
    if (ret.code === 0) {
      $("#workDirectory").val(ret.data[0].confValue);
    } else {
      console.log(ret.msg);
    }
  });
  fetchJSON("api/config/getIT", {}, "post", function(ret) {
    if (ret.code === 0) {
      $("#timeout").val(ret.data[0].confValue / 1000);
    } else {
      console.log(ret.msg);
    }
  });
  fetchJSON("api/config/getME", {}, "post", function(ret) {
    if (ret.code === 0) {
      $("#errorTimes").val(ret.data[0].confValue);
    } else {
      console.log(ret.msg);
    }
  });

  fetchJSON("api/server/getDMS", {}, "post", function(ret) {
    if (ret.code === 0) {
      $("#monitorStatus").html(ret.data == "正在监控目录变化情况" ? "正在运行..." : "已停止");
      $("#stopMonitor").text(ret.data == "正在监控目录变化情况" ? "停止监控" : "启动监控");
    } else {
      console.log(ret.msg);
    }
  });

  $("#stopMonitor").on("click", function(e) {
    e.preventDefault();
    if ($(this).text() == "停止监控") {
      $(this).text("启动监控");
      $("#monitorStatus").html("已停止");
      fetchJSON("api/server/stopDM", {}, "post", function(ret) {
        if (ret.code === 0) {
        } else {
          console.log(ret.msg);
        }
      });
    } else {
      $(this).text("停止监控");
      $("#monitorStatus").html("正在运行...");
      fetchJSON("api/server/startDM", {}, "post", function(ret) {
        if (ret.code === 0) {
        } else {
          console.log(ret.msg);
        }
      });
    }
  });

  $("#executeAnalysis").on("click", function(e) {
    fetchJSON("api/server/startAT", {}, "post", function(ret) {
      console.log(ret);
    });
  });

  $("#save").on("click", function(e) {
    e.preventDefault();
    var value = $("#submitDirectory")
      .val()
      .trim();
    fetchJSON("api/config/setSD", { confValue: value }, "post", function(ret) {
      if (ret.code !== 0) {
        console.log(ret.msg + ret.data);
      }
    });
    value = $("#resourceDirectory")
      .val()
      .trim();
    fetchJSON("api/config/setRD", { confValue: value }, "post", function(ret) {
      if (ret.code !== 0) {
        console.log(ret.msg + ret.data);
      }
    });
    value = $("#workDirectory")
      .val()
      .trim();
    fetchJSON("api/config/setWD", { confValue: value }, "post", function(ret) {
      if (ret.code !== 0) {
        console.log(ret.msg + ret.data);
      }
    });
    value = $("#timeout")
      .val()
      .trim();
    fetchJSON("api/config/setIT", { confValue: value * 1000 }, "post", function(ret) {
      if (ret.code !== 0) {
        console.log(ret.msg + ret.data);
      }
    });
    value = $("#errorTimes")
      .val()
      .trim();
    fetchJSON("api/config/setME", { confValue: value }, "post", function(ret) {
      if (ret.code !== 0) {
        console.log(ret.msg + ret.data);
      }
    });
  });

  $("#reset").on("click", function(e) {
    e.preventDefault();
    location.replace(location.href);
  });

  $("#initES").on("click", function(e) {
    e.preventDefault();
    fetchJSON("api/server/initES", {}, "post", function(ret) {
      if (ret.code !== 0) {
        console.log(ret.msg + ret.data);
      }
    });
  });
});
