/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.StringArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JInternalFrame;

public class SelectedPages
extends AbstractTool {
    public SelectedPages() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to split", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the first part of the original PDF has to be written", true, new PdfFilter()));
        this.arguments.add(new StringArgument(this, "selection", "A selection of pages (see Help for more info)"));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("SelectedPages", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== SelectedPages OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file for the first part of the PDF");
            }
            File file2 = (File)this.getValue("destfile");
            String string = (String)this.getValue("selection");
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            System.out.println("The original file had " + pdfReader.getNumberOfPages() + " pages.");
            pdfReader.selectPages(string);
            int n = pdfReader.getNumberOfPages();
            System.err.println("The new file has " + n + " pages.");
            Document document = new Document(pdfReader.getPageSizeWithRotation(1));
            PdfCopy pdfCopy = new PdfCopy(document, (OutputStream)new FileOutputStream(file2.getAbsolutePath()));
            document.open();
            int n2 = 0;
            while (n2 < n) {
                System.out.println("Processed page " + ++n2);
                PdfImportedPage pdfImportedPage = pdfCopy.getImportedPage(pdfReader, n2);
                pdfCopy.addPage(pdfImportedPage);
            }
            PRAcroForm pRAcroForm = pdfReader.getAcroForm();
            if (pRAcroForm != null) {
                pdfCopy.copyAcroForm(pdfReader);
            }
            document.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valueHasChanged(AbstractArgument abstractArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        SelectedPages selectedPages = new SelectedPages();
        if (stringArray.length < 4) {
            System.err.println(selectedPages.getUsage());
        }
        selectedPages.setMainArguments(stringArray);
        selectedPages.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        SelectedPages.addVersion("$Id: SelectedPages.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

