/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.swing;

import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PdfInformationPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -4171577284617028707L;
    String filename = "";
    JLabel label = new JLabel();
    JScrollPane scrollpane = new JScrollPane();
    JPanel panel = new JPanel();

    public PdfInformationPanel() {
        try {
            this.setLayout(new BorderLayout());
            this.label.setHorizontalAlignment(0);
            this.panel.setLayout(new BorderLayout());
            this.add((Component)this.panel, "Center");
            this.scrollpane.setPreferredSize(new Dimension(200, 200));
            this.panel.add((Component)this.scrollpane, "Center");
            this.scrollpane.setViewportView(this.label);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void createTextFromPDF(File file) {
        if (file.exists()) {
            int n = 1;
            PdfReader pdfReader = null;
            try {
                pdfReader = new PdfReader(new RandomAccessFileOrArray(file.getAbsolutePath()), null);
                HashMap hashMap = pdfReader.getInfo();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>=== Document Information ===<p>");
                stringBuffer.append(pdfReader.getCropBox(n).getHeight() + "*" + pdfReader.getCropBox(n).getWidth() + "<p>");
                stringBuffer.append("PDF Version: " + pdfReader.getPdfVersion() + "<p>");
                stringBuffer.append("Number of pages: " + pdfReader.getNumberOfPages() + "<p>");
                stringBuffer.append("Number of PDF objects: " + pdfReader.getXrefSize() + "<p>");
                stringBuffer.append("File length: " + pdfReader.getFileLength() + "<p>");
                stringBuffer.append("Encrypted= " + pdfReader.isEncrypted() + "<p>");
                if (hashMap.get("Title") != null) {
                    stringBuffer.append("Title= " + (String)hashMap.get("Title") + "<p>");
                }
                if (hashMap.get("Author") != null) {
                    stringBuffer.append("Author= " + (String)hashMap.get("Author") + "<p>");
                }
                if (hashMap.get("Subject") != null) {
                    stringBuffer.append("Subject= " + (String)hashMap.get("Subject") + "<p>");
                }
                if (hashMap.get("Producer") != null) {
                    stringBuffer.append("Producer= " + (String)hashMap.get("Producer") + "<p>");
                }
                if (hashMap.get("ModDate") != null) {
                    stringBuffer.append("ModDate= " + PdfDate.decode((String)hashMap.get("ModDate")).getTime() + "<p>");
                }
                if (hashMap.get("CreationDate") != null) {
                    stringBuffer.append("CreationDate= " + PdfDate.decode((String)hashMap.get("CreationDate")).getTime() + "<p>");
                }
                stringBuffer.append("</html>");
                this.label.setText(stringBuffer.toString());
            }
            catch (IOException iOException) {
                this.label.setText("");
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        File file;
        this.filename = propertyChangeEvent.getPropertyName();
        if (this.filename.equals("SelectedFileChangedProperty") && (file = (File)propertyChangeEvent.getNewValue()) != null) {
            this.createTextFromPDF(file);
            this.repaint();
        }
    }
}

