window.onload = function() {
	//现在时间
	var articleType = 0;
	var searchTitleKey = "";
	var defaultPage = 0;
	var defaultSize = 10;
	var currentPage = defaultPage;
	var currentSize = defaultSize;
	var tableFirstLoad = true;
	var title = $("#title");
	var defaultYear = new Date().getFullYear(); //年份
	var defaultStart = Date.parse(new Date(defaultYear.toString()));
	var timeNow = new Date().getTime();
	var tableOption = {
		elem: "#articleList",
		height: "full-400",
		cols: [
			[{
					type: "checkbox"
				},
				{
					field: "departmentName",
					title: "单位名称",
					align: "center"
				},
				{
					field: "authorName",
					title: "作者名称",
					align: "center"
				},
				{
					field: "countId",
					title: "提交数量",
					align: "center"
				},
				{
					field: "sumViewTime",
					title: "总查看次数",
					align: "center"
				},
				{
					field: "sumDownloadTime",
					title: "总下载次数",
					align: "center"
				},
				{
					field: "avgSatisfaction",
					title: "平均满意度",
					align: "center"
				},
				{
					fixed: "right",
					title: "操作",
					toolbar: "#operationToolbar",
					width: 100,
					align: "center"
				}
			]
		]
	};
	layui.use(["form", "table", "laypage", "layer"], function() {
		var form = layui.form;
		var table = layui.table;
		var laypage = layui.laypage;

		function loadArticleList(page, size) {
			if (page === null || page === undefined) page = defaultPage;
			if (size === null || size === undefined) size = defaultSize;
			var searchKey = title.val().trim();
			var Vale = $(".atr .layui-this").attr("lay-value");
			var url = "api/statistics/total?endTime=" + timeNow + "&order=countId" + "&page=" + page + "&size=" + size +
				"&startTime=" + defaultStart;
			if (Vale == 1) {
				url = "api/statistics/department?department=" + searchKey + "&endTime=" + timeNow + "&order=countId" + "&page=" +
					page + "&size=" + size + "&startTime=" + defaultStart;
				url = encodeURI(url);
				url = decodeURI(url);
			} else if (Vale == 2) {
				url = "api/statistics/author?author=" + searchKey + "&endTime=" + timeNow + "&order=countId" + "&page=" + page +
					"&size=" + size + "&startTime=" + defaultStart;
				url = encodeURI(url);
				url = decodeURI(url);
			}
			fetchJSON(url, {}, "post", function(data) {
				if (data.code === 0) {
					var articles = data.data.content;
					for (var i = 0; i < articles.length; i++)
						articles[i].resourceCollectDate = timestampToTime(articles[i].resourceCollectDate);

					if (tableFirstLoad) {
						tableFirstLoad = false;
						laypage.render({
							curr: page + 1,
							elem: "pagination",
							count: data.data.totalElements,
							layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
							jump: function(obj, first) {
								if (first) return;
								currentPage = obj.curr - 1;
								currentSize = obj.limit;
								loadArticleList(currentPage, currentSize);
							}
						});
					}
					tableOption.limit = size;
					tableOption.data = articles;
					table.render(tableOption);
				} else {
					showMsg(data.msg, 2, 2000);
				}
			});
		}

		// loadArticleList();

		fetchJSON("api/resource/years", {}, "get", function(ret) {
			if (ret.code === 0) {
				$("#dateScope").empty();
				for (var i = 0; i < ret.data.length; i++) {
					$("#dateScope").append($("<option>", {
						value: ret.data[i],
						text: ret.data[i]
					}));
				}
				layui.use("form", function() {
					layui.form.render();
				});

				var dateScope = $("#dateScope").val();

				var end = parseInt(parseInt(dateScope) + 1); //结束时间
				end = end.toString();
				var start = Date.parse(new Date(dateScope)); //起始时间
				var end = Date.parse(new Date(end)); //结束时间戳
				timeNow = end; //结束时间
				defaultStart = start; //起止时间
				tableFirstLoad = true;
				loadArticleList(0, currentSize, articleType, searchTitleKey);
			} else {
				console.log(ret.msg);
			}
		});

		table.on("tool(articleList)", function(obj) {
			var data = obj.data;
			if (obj.event === "detail") {
				var dept = "",
					author = "";
				if (data.departmentName !== null && data.departmentName !== undefined)
					dept = data.departmentName;
				if (data.authorName !== null && data.authorName !== undefined)
					author = data.authorName;
				x_admin_show("查看详情", "spcDetail.html?d=" + dept + "&a=" + author + "&y=" + $('#dateScope').val(),
					400, 600,
					function() {});
			}
		});

		form.on("select(articleType)", function(e) {
			articleType = e.value;
			tableFirstLoad = true;
			loadArticleList(0, currentSize, articleType, searchTitleKey);
		});

		form.on("select(dateScope)", function(e) {
			dateScope = e.value;
			var end = parseInt(parseInt(dateScope) + 1); //结束时间
			end = end.toString();
			var start = Date.parse(new Date(dateScope)); //起始时间
			var end = Date.parse(new Date(end)); //结束时间戳
			timeNow = end; //结束时间
			defaultStart = start; //起止时间
			tableFirstLoad = true;
			loadArticleList(0, currentSize, articleType, searchTitleKey);
		});


		$("#searchArticle").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			searchTitleKey = title.val().trim();
			loadArticleList(0, currentSize, articleType, searchTitleKey);
		});
		title.on("keyup", function(e) {
			tableFirstLoad = true;
			searchTitleKey = title.val().trim();
			loadArticleList(0, currentSize, articleType, searchTitleKey);
		});
	});

	//数据提交量（上面）
	fetchJSON("api/statistics/commitTotal", {}, "get", function(data) {
		$("#data_sub").html(data.data.total);
		$("#day_mean").html(data.data.avgOfDay);

	});
	//访问量小图（上面）
	fetchJSON("api/statistics/view?endTime=" + timeNow + "&startTime=1514764800000", {}, "get", function(data) {
		var data = data.data;
		var amountAccess = echarts.init(document.getElementById('amountAccess'));
		//获取数据渲染表格
		$("#pv").html(data.total); //访问量
		// $("#day_pv").html(); //日访问量
		var obj = data.elements;
		var obj_i = [];
		var obj_val = [];
		for (var i = 0; i < obj.length; i++) {
			obj_i.push(i + 1);
			obj_val.push(obj[i].value);
		}
		optionAmountAccess = {
			xAxis: {
				type: 'category',
				boundaryGap: false,
				data: obj_i,
				splitLine: {
					show: false
				},
				show: false
			},
			yAxis: {
				type: 'value',
				show: false
			},
			series: [{
				symbol: "none",
				data: obj_val,
				type: 'line',
				itemStyle: {
					normal: {
						color: 'rgba(118, 18, 247,.6)'
					}
				},
				areaStyle: {
					normal: {
						color: 'rgb(118, 18, 247)'
					}
				}
			}]
		};
		amountAccess.setOption(optionAmountAccess);
	});
	//下载量小图（上面）
	fetchJSON("api/statistics/download?endTime=" + timeNow + "&startTime=1514764800000", {}, "get", function(data) {

		var Downloads = echarts.init(document.getElementById('Downloads'));
		$("#down_num").html(data.data.total); //下载量
		//  $("#rate").html(); //转换率
		// 指定图表的配置项和数据
		var data = data.data;
		var obj = data.elements;
		var obj_i = [];
		var obj_val = [];
		for (var i = 0; i < obj.length; i++) {
			obj_i.push(i + 1);
			obj_val.push(obj[i].value);
		}
		var optionDownloads = {
			legend: {
				show: false
			},
			xAxis: {
				data: obj_i,
				splitLine: {
					show: false
				},
				show: false
			},
			yAxis: {
				splitLine: {
					show: false
				},
				show: false
			},

			series: [{
				name: '下载量',
				type: 'bar',
				itemStyle: {
					normal: {
						color: new echarts.graphic.LinearGradient(
							0, 0, 0, 1,
							[{
									offset: 0,
									color: '#83bff6'
								},
								{
									offset: 0.5,
									color: '#188df0'
								},
								{
									offset: 1,
									color: '#188df0'
								}
							]
						)
					}
				},
				barWidth: 8,
				data: obj_val
			}]
		};
		// 使用刚指定的配置项和数据显示图表。
		Downloads.setOption(optionDownloads);
	});
};
