$(function() {
	var articleType = 0;
	var searchTitleKey = "";
	var defaultPage = 0;
	var isError = 0;
	var defaultSize = 10;
	var currentPage = defaultPage;
	var currentSize = defaultSize;
	var tableFirstLoad = true;
	var title = $("#title");

	var tableOption = {
		elem: "#articleList",
		height: "full-81",
		cols: [
			[{
					type: "checkbox"
				},
				{
					field: "resourceName",
					title: "资源名称",
					align: "center"
				},
				{
					field: "submitDepartment",
					title: "提供单位",
					align: "center"
				},
				{
					field: "resourceAuthor",
					title: "提供者",
					align: "center"
				},
				{
					field: "resourceCollectDate",
					title: "提供日期",
					align: "center"
				},
				{
					field: "resourceFormat",
					title: "资源类型",
					align: "center"
				},
				{
					fixed: "right",
					title: "操作",
					toolbar: "#operationToolbar",
					width: 100,
					align: "center"
				}
			]
		]
	};

	layui.use(["form", "table", "laypage", "layer"], function() {
		var form = layui.form;
		var table = layui.table;
		var laypage = layui.laypage;
		var layer = layui.layer;

		function loadArticleList(page, size) {
			if (page === null || page === undefined) page = defaultPage;
			if (size === null || size === undefined) size = defaultSize;

			var url = "api/resource/list?title=" + searchTitleKey + "&isError=" + isError + "&page=" + page + "&size=" +
				size;

			fetchJSON(url, {}, "post", function(data) {
				if (data.code === 0) {
					var articles = data.data.content;
					for (var i = 0; i < articles.length; i++)
						articles[i].resourceCollectDate = timestampToTime(articles[i].resourceCollectDate);

					if (tableFirstLoad) {
						tableFirstLoad = false;
						laypage.render({
							curr: page + 1,
							elem: "pagination",
							count: data.data.totalElements,
							layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
							jump: function(obj, first) {
								if (first) return;
								currentPage = obj.curr - 1;
								currentSize = obj.limit;
								loadArticleList(currentPage, currentSize, searchTitleKey);
							}
						});
					}
					tableOption.limit = size;
					tableOption.data = articles;
					table.render(tableOption);
				} else {
					showMsg(data.msg, 2, 2000);
				}
			});
		}

		loadArticleList();


		form.on("select(articleType)", function(e) {
			articleType = e.value;
			tableFirstLoad = true;
			loadArticleList(0, currentSize, articleType, searchTitleKey);
		});

		$("#searchArticle").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			isError = 0;
			searchTitleKey = title.val().trim();
			loadArticleList(0, currentSize, articleType, searchTitleKey);
		});
		$("#showErrorResource").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			searchTitleKey = '';
			isError = 1;
			loadArticleList(0, currentSize, articleType, searchTitleKey);
		});
		/*title.on("keyup", function (e) {
		  tableFirstLoad = true;
		  searchTitleKey = title.val().trim();
		  loadArticleList(0, currentSize, articleType, searchTitleKey);
		});*/

		// 监听表内工具条
		table.on("tool(articleList)", function(obj) {
			var data = obj.data;

			// 删除
			var ids = [];
			ids.push(data.id);
			layer.confirm("确认要删除吗？", function() {
				fetchJSON("api/resource/realDelete", ids, "delete", function(data) {
					if (data.code === 0) {
						showMsg("已删除!");
						tableFirstLoad = true;
						loadArticleList(currentPage, currentSize);
					} else {
						showMsg(code.msg, 2, 2000);
					}
				});
			});

		});

	});
});
