$(function() {
    var params = window.location.href.split("?");
    if (params.length > 1) {
        values = params[1].split("&");
        if (values.length > 2) {
            var funcId = values[0].replace("id=", "");
            var funcfaultDefect = "";
            var funcdescribes = "";

            if (funcId !== "0") {
                funcfaultDefect = decodeURI(values[1].replace("faultDefect=", ""));
                funcdescribes = decodeURI(values[2].replace("describes=", ""));

            }
        }
    }

    $("#faultDefect").val(funcfaultDefect);
    $("#describes").val(funcdescribes);
    layui.use("form", function() {
        layui.form.render();
    });

    layui.use(["form", "layer"], function() {
        $ = layui.jquery;
        var form = layui.form,
            layer = layui.layer;
        //监听提交
        form.on("submit(save)", function(data) {
            if ($("#faultDefect").val().trim() === "") {
                showMsg("故障缺陷不能为空", 2);
                $("#faultDefect").focus();
                return false;
            }
            var func = data.field;
            func.id = funcId;
            let url = "";
            if (func.id === "0") url = "api/faultDefect/add";
            else url = "api/faultDefect/edit";
            fetchJSON(url, func, "post", function(data) {
                if (data.status === 0) {
                    var index = parent.layer.getFrameIndex(window.name);
                    showMsg("修改成功", 1, 2000);
                    parent.layer.close(index);
                } else {
                    showMsg(data.msg, 2);
                }
            });
            return false;
        });

    });
});