$(function () {
    var params = window.location.href.split("?");
    if (params.length > 1) {
        values = params[1].split("&");
        if (values.length > 4) {
            var departmentId = values[0].replace("id=", "");
            var departmentName = "";
			var masterId ="";
			var masterName ="";
            var parentId = "";
			var parentName ="";
            var purpose = "";
            if (departmentId !== "0") {
                departmentName = decodeURI(values[1].replace("departmentName=", ""));
				// masterId = decodeURI(values[2].replace("masterId=", ""));
				masterName = decodeURI(values[2].replace("masterName=", ""));
				parentName = decodeURI(values[3].replace("parentName=", ""));
                // parentId = decodeURI(values[4].replace("parentId=", ""));
                purpose = decodeURI(values[4].replace("remark=", ""));
            }
        }
    }

    $("#departmentName").val(departmentName);
	// $("#masterId").val(masterId);
	$("#masterName").val(masterName);
	$("#parentName").val(parentName);
	// $("#parentId").val(parentId);
	$("#departmentName").val(departmentName);
    $("#remark").val(purpose);

    fetchJSON("api/department/listAll?page=1&size=1000", {}, "get", function (departmentList) {
        if (departmentList.status === 0) {
            $("#parentId").empty();
            $("#parentId").append($("<option>", {value: -1, text: "请选择"}));

            for (let i = 0; i < departmentList.data.length; i++) {
                if (departmentList.data[i].id == parentId) {
                    $("#parentId").append(
                        $("<option>", {
                            value:departmentList.data[i].id,
                            text: departmentList.data[i].departmentName ,
                            selected: true
                        })
                    );
                } else {
                    $("#parentId").append(
                        $("<option>", {
                            value:departmentList.data[i].id,
                            text: departmentList.data[i].departmentName ,
                        })
                    );
                }
            }
            layui.use("form", function () {
                layui.form.render();
            });
        } else {
            showMsg(ret.msg, 2);
        }
    });
    layui.use(["form", "layer"], function () {
        $ = layui.jquery;
        var form = layui.form,
            layer = layui.layer;
        //监听提交

        form.on("submit(add)", function (data) {
            if ($("#departmentName").val().trim() === "") {
                showMsg("单位名不能为空!", 2);
                $("#departmentName").focus();
                return false;
            }
            let department = data.field;
            if (departmentId < 0)
                department.id = 0;
            else department.id = departmentId;
            department.departmentName = $("#departmentName").val().trim();
            department.parentId = $("#parentId").val();
            if (department.parentId < 0) department.parentId = 0;
            department.remark = $("#remark").val();
            let url = "";
            if (department.id === "0") url = "api/department/add" ;
            else url = "api/department/edit";
            fetchJSON(url,department, "post", function (data) {
                if (data.status === 0) {
                    layer.alert("保存成功", {icon: 6}, function () {
                        var index = parent.layer.getFrameIndex(window.name);
                        parent.layer.close(index);
                    });
                } else {
                    showMsg(data.msg, 2);
                }
            });
            return false;
        });

    form.on('select(parentId)', function (data) {
        parentName = data.elem[data.elem.selectedIndex].text;
    })

    });
});
