$(function() {
    var defaultPage = 0;
    var defaultSize = 10;
    var currentPage = defaultPage;
    var currentSize = defaultSize;
    var tableFirstLoad = true;
    layui.config({
        base: './lib/layui_exts/'
    }).use(["form", "table", 'excel', "laypage", "layer"], function() {
        var table = layui.table;
        var laypage = layui.laypage;
        var layer = layui.layer;
        excel = layui.excel;
        var title = $("#realName");
        var searchTitleKey = "";
        var device_name = $("#device_name")
        var startTime = $("#startTime")
        var endTime = $("#endTime")
            // var searchTitleName = "";
        var searchTitleTime = "";
        var searchTitleTime1 = ""

        function loadAirList(page, size, searchTitle) {
            if (page === null || page === undefined) page = defaultPage;
            if (size === null || size === undefined) size = defaultSize;

            var tableOption = {
                elem: "#faultrecord",
                height: "full-81",
                limit: size,
                cols: [
                    [{
                            field: "device_name",
                            title: "故障件名称",
                            align: "center",
                        },
                        {
                            field: "aircraft_type",
                            title: "机型",
                            align: "center"

                        },
                        {
                            field: "fault_degree",
                            title: "故障性质",
                            align: "center"
                        },
                        {
                            field: "#fault_reason",
                            title: "故障原因",
                            align: "center"
                        },
                        {
                            field: "repair_method",
                            title: "排除方法",
                            align: "center"
                        },


                    ]
                ]
            };
            // var device_name.val() = "发动机"
            if (title.val() === "" || startTime.val() === "" || endTime.val() === "") {
                var url = "api/faultrecord/listpage?page=" + (page + 1) + "&size=" + size;
            } else {
                var url = "api/faultrecord/faultsta?name=" + device_name.val() + "&startTime=" + startTime.val() +
                    "&endTime=" + endTime.val() + "&page=" + (page + 1) + "&size=" + size;
            }
            fetchJSON(url, {}, "get", function(data) {
                if (data.status === 0) {
                    if (tableFirstLoad) {
                        tableFirstLoad = false;
                        laypage.render({
                            curr: page + 1,
                            elem: "pagination",
                            count: data.data.total,
                            layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
                            jump: function(obj, first) {
                                if (first) return;
                                currentPage = obj.curr - 1;
                                currentSize = obj.limit;
                                loadAirList(currentPage, currentSize, searchTitleKey);
                            }
                        });
                    }
                    // console.log(data.data.total)
                    tableOption.data = data.data.list;
                    table.render(tableOption);
                    // var total = data.data.total
                    // sessionStorage.setItem("name",total)
                } else {
                    showMsg(data.msg, 2, 2000);
                }
            });
        }


        loadAirList();


        //统计
        $("#sure").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            var searchTitleKey = device_name.val().trim();
            var searchTitleTime = startTime.val().trim();
            var searchTitleTime1 = endTime.val().trim();
            if (searchTitleKey === "")
                loadAirList(0, currentSize);
            else
                loadAirList(0, currentSize, searchTitleKey);


        })

        $("#searchArticle").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            searchTitleKey = title.val().trim();
            if (searchTitleKey === "")
                loadAirList(0, currentSize);
            else
                loadAirList(0, currentSize, searchTitleKey);
        });


        $("#keyword").on("keyup", function(e) {
            e.preventDefault();
            if (e.keyCode === 13) {
                $("#searchArticle").click();
            }
        });

        // 监听表内工具条
        table.on("tool(faultrecord)", function(obj) {
            var data = obj.data;
            // console.log(data)
            if (obj.event === "edit") {
                console.log(data)
                    // 打开编辑框 进行详细编辑
                x_admin_show(
                    "查看",
                    encodeURI(
                        "../admin/faultrecord-add.html?id=" + data.id + "&War_zone=" + data.war_zone + "&army=" + data.army +
                        "&division=" + data.division + "&brigade=" + data.brigade + "&fault_time=" + data.fault_time +
                        "&Is_history=" + data.is_history + "&Aircraft_type=" + data.aircraft_type + "&Discover_opportunity=" +
                        data.discover_opportunity + "&Up_down=" + data.up_down + "&Discoverer=" + data.discoverer +
                        "&Info_sources=" + data.info_sources + "&fault_content=" + data.fault_content + "&Is_falsealarm=" + data.is_falsealarm +
                        "&Fault_degree=" + data.fault_degree + "&Fault_consequence=" + data.fault_consequence +
                        "&Miss_flight_times=" + data.missflight_times + "&Impact_times=" + data.impact_times + "&Fault_liability=" +
                        data.fault_liability + "&Fault_location=" + data.fault_location + "&major=" + data.major +
                        "&fault_reason=" + data.fault_reason + "&Reviewer=" + data.reviewer + "&review_time=" + data.review_time +
                        "&repair_time=" + data.repair_time + "&repair_hours=" + data.repair_hours + "&repair_personnum=" + data.repair_personnum +
                        "&repaired_time=" + data.repaired_time + "&classification=" + data.classification + "&is_grounded=" + data
                        .is_grounded + "&Reporting_department=" + data.reporting_department + "&device_name=" + data.device_name +
                        "&device_type=" + data.device_type + "&replace_device=" + data.replace_device + "&replace_type=" + data.replace_type +
                        "&Diagnosis_method=" + data.diagnosis_method + "&diagnosis_people=" + data.diagnosis_people +
                        "&faultparts_date=" + data.faultparts_date + "&faultparts_hours=" + data.faultparts_hours +
                        "&faultparts_worktimes=" + data.faultparts_worktimes + "&faultparts_renovation_manu=" + data.faultparts_renovation_manu +
                        "&Faultparts_Renovation_hours=" + data.faultparts_Renovation_hours + "&Faultparts_Renovation_times=" +
                        data.faultparts_Renovation_times + "&repair_method=" + data.repair_method + "&Repair_person=" + data.repair_person +
                        "&replace_device_hours=" + data.replace_device_hours + "&replace_device_repairhours" + data.replace_device_repairhours +
                        "&replace_device_repairtimes=" + data.replace_device_repairtimes + "&replace_device_applytimes=" + data.replace_device_applytimes +
                        "&replace_device_manufacturer=" + data.replace_device_manufacturer + "&Faultparts_system=" + data.faultparts_system +
                        "&Inspector=" + data.inspector + "&Handling_opinions=" + data.handling_opinions + "&remark=" + data.remark

                    ),
                    1300,
                    600,
                    function() {
                        loadAirList(currentPage, currentSize);
                    }
                );
            } else
            if (obj.event === "delete") {
                // console.log(data)
                // 删除
                var ids = [];
                ids.push(data.id);
                layer.confirm("确认要删除吗？", function() {
                    fetchJSON("api/faultrecord/delete", {
                        ids: ids
                    }, "post", function(data) {
                        if (data.status === 0) {
                            showMsg("已删除!", 1, 2000);
                            tableFirstLoad = true;
                            loadAirList(currentPage, currentSize);
                        } else {
                            showMsg(data.msg, 2, 2000);
                        }
                    });
                });
            }
        });

        //表格导入
        $("#tolead").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            x_admin_show("导入",
                "../admin/faul-add.html",
                350,
                200,
                function() {
                    loadAirList(currentPage, currentSize);
                });
        });

        //表格导出
        function exportFile(id) {

            //根据传入tableID获取表头
            var headers = layui.$("div[lay-id='faultrecord'] .layui-table-box table").get(0);
            var htrs = Array.from(headers.querySelectorAll('tr'));
            var titles = {};
            for (var j = 0; j < htrs.length; j++) {
                var hths = Array.from(htrs[j].querySelectorAll("th"));
                for (var i = 1; i < hths.length - 1; i++) {

                    //排除居左、具有、隐藏字段
                    //修改:默认字段data-field+i,兼容部分数据表格中不存在data-field值的问题
                    titles['data-field' + i] = hths[i].innerText;
                }
            }

            //根据传入tableID获取table内容
            var bodys = layui.$("div[lay-id='faultrecord'] .layui-table-box table").get(1);
            var btrs = Array.from(bodys.querySelectorAll("tr"))
            var bodysArr = new Array();
            for (var j = 0; j < btrs.length; j++) {
                var contents = {};
                var btds = Array.from(btrs[j].querySelectorAll("td"));
                for (var i = 1; i < btds.length - 1; i++) {
                    for (var key in titles) {
                        //修改:默认字段data-field+i,兼容部分数据表格中不存在data-field值的问题
                        var field = 'data-field' + i;
                        if (field === key) {
                            //根据表头字段获取table内容字段
                            contents[field] = btds[i].innerText;
                        }
                    }
                }
                bodysArr.push(contents)
            }
            //将标题行置顶添加到数组
            bodysArr.unshift(titles);
            //导出excel
            excel.exportExcel({
                sheet1: bodysArr
            }, '故障记录' + new Date().toLocaleString() + '.xlsx', 'xlsx');
        }

        $("#exportLog").on("click", function(e) {
            exportFile("faultrecord");
        });
        // 批量删除
        $("#batchDelete").on("click", function(e) {
            e.preventDefault();
            var checkedData = table.checkStatus("faultrecord").data;
            if (checkedData.length === 0) {
                showMsg("未选择需要删除的日志", 2, 2000);
                return;
            }
            layer.confirm("确认要删除吗？", function() {
                var ids = [];
                for (var i = 0; i < checkedData.length; i++) {
                    ids.push(checkedData[i].id);
                }

                fetchJSON("api/faultrecord/delete", {
                    ids: ids
                }, "post", function(data) {
                    if (data.status === 0) {
                        showMsg("已删除!");
                        tableFirstLoad = true;
                        loadAirList(currentPage, currentSize);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            });
        });
        // 新建用户
        $("#addair").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            x_admin_show("添加",
                "../admin/faultrecord-edit.html?id=0&war_zone=&army=&division=&brigade=&fault_time=&is_history=&aircraft_type=&Ddiscover_opportunity=&up_down=&discoverer=&info_sources=&fault_content=&is_falsealarm=&fault_degree=&fault_consequence=&miss_flight_times=&impact_times=&fault_liability=&fault_location=&major=&fault_reason=&reviewer=&review_time=&repair_time=&repair_hours=&repair_personnum=&repaired_time=&classification=&is_grounded=&reporting_department=&device_name=&device_type=&replace_device=&replace_type=&diagnosis_method=&diagnosis_people=&faultparts_date=&faultparts_hours=&faultparts_ worktimes=&faultparts_renovation_manu=&faultparts_Renovation_hours=&faultparts_Renovation_times=&repair_method=&repair_person=&replace_device_hours=&replace_device_repairhours=&replace_device_repairtimes=&replace_device_applytimes=&replace_device_manufacturer=&Faultparts_system=&Inspector=&handling_opinions=&remark=",
                1300,
                500,
                function() {
                    loadAirList(currentPage, currentSize);
                });
        });


    });
});