$(function() {
    var defaultPage = 0;
    var defaultSize = 10;
    var currentPage = defaultPage;
    var currentSize = defaultSize;
    var tableFirstLoad = true;

    layui.use(["form", "table", "laypage", "layer"], function() {
        var table = layui.table;
        var laypage = layui.laypage;
        var layer = layui.layer;
        var title = $("#realName");
        var searchTitleKey = "";

        function loadAirList(page, size, searchTitle) {
            if (page === null || page === undefined) page = defaultPage;
            if (size === null || size === undefined) size = defaultSize;
            var tableOption = {
                elem: "#airList",
                height: "full-81",
                limit: size,
                cols: [
                    [{
                            type: "checkbox"
                        },
                       
                        {
                            field: "aircraft_type",
                            title: "机型",
                            align: "center",
							 width: 200,
                        },
      //                   {
      //                       field: "input_time",
      //                       title: "开始时间",
      //                       align: "center"
      //                   },
						// {
						//     field: "ending_time",
						//     title: "结束时间",
						//     align: "center"
						// },
      //                   {
      //                       field: "file_path",
      //                       title: "地址",
      //                       align: "center"
      //                   },
						{
						    field: "aircraft_describe",
						    title: "备注",
						    align: "center"
						},
                        {
                            fixed: "right",
                            title: "操作",
                            width: 265,
                            toolbar: "#operationToolbar",
                            align: "center"
                        }
                    ]
                ]
            };

            if (searchTitle === null || searchTitle === undefined || searchTitle === "") {
                fetchJSON("api/aircraft/listpage?page=" + (page + 1) + "&size=" + size, {}, "get", function(data) {
                    if (data.status === 0) {
                        if (tableFirstLoad) {
                            tableFirstLoad = false;
                            laypage.render({
                                curr: page + 1,
                                elem: "pagination",
                                count: data.data.total,
                                layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
                                jump: function(obj, first) {
                                    if (first) return;
                                    currentPage = obj.curr - 1;
                                    currentSize = obj.limit;
                                    loadAirList(currentPage, currentSize, searchTitleKey);
                                }
                            });
                        }

                        tableOption.data = data.data.list;
                        table.render(tableOption);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            } else {
                fetchJSON("api/aircraft/getByName?name=" + searchTitle, {}, "get", function(data) {
                    if (data.status === 0) {
                        if (tableFirstLoad) {
                            tableFirstLoad = false;
                            laypage.render({
                                curr: page + 1,
                                elem: "pagination",
                                count: data.data.length,
                                layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
                                jump: function(obj, first) {
                                    if (first) return;
                                    currentPage = obj.curr - 1;
                                    currentSize = obj.limit;
                                    loadAirList(currentPage, currentSize, searchTitleKey);
                                }
                            });
                        }

                        tableOption.data = data.data;
                        table.render(tableOption);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            }


        }

        loadAirList();

        $("#searchArticle").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            searchTitleKey = title.val().trim();
            if (searchTitleKey === "")
                loadAirList(0, currentSize);
            else
                loadAirList(0, currentSize, searchTitleKey);
        });


        $("#keyword").on("keyup", function(e) {
            e.preventDefault();
            if (e.keyCode === 13) {
                $("#searchArticle").click();
            }
        });

        // 监听表内工具条
        table.on("tool(airList)", function(obj) {
            var data = obj.data;
            if (obj.event === "edit") {
                // 打开编辑框 进行详细编辑
                x_admin_show(
                    "编辑机型",
                    encodeURI(
                        "../admin/aircraft-edit.html?id=" + data.id + "&aircraft_type=" + data.aircraft_type + "&aircraft_describe=" + data.aircraft_describe
                    ),
					463,
					275,
                    function() {
                        loadAirList(currentPage, currentSize);
                    }
                );
            } else if (obj.event === "delete") {
                // 删除
                var ids = [];
                ids.push(data.id);
                layer.confirm("确认要删除吗？", function() {
                    fetchJSON("api/aircraft/delete", {
                        ids: ids
                    }, "post", function(data) {
                        if (data.status === 0) {
                            showMsg("已删除!", 1, 2000);
                            tableFirstLoad = true;
                            loadAirList(currentPage, currentSize);
                        } else {
                            showMsg(data.msg, 2, 2000);
                        }
                    });
                });
            }
        });
        // 批量删除
        $("#batchDelete").on("click", function(e) {
            e.preventDefault();
            var checkedData = table.checkStatus("airList").data;
            if (checkedData.length === 0) {
                showMsg("未选择需要删除的日志", 2, 2000);
                return;
            }
            layer.confirm("确认要删除吗？", function() {
                var ids = [];
                for (var i = 0; i < checkedData.length; i++) {
                    ids.push(checkedData[i].id);
                }

                fetchJSON("api/aircraft/delete", {
                    ids: ids
                }, "post", function(data) {
                    if (data.status === 0) {
                        showMsg("已删除!");
                        tableFirstLoad = true;
                        loadAirList(currentPage, currentSize);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            });
        });
        // 新建用户
        $("#addair").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            x_admin_show("增加",
                "../admin/aircraft-edit.html?id=0&aircraft_type=&aircraft_describe=",
                463,
                275,
                function() {
                    loadAirList(currentPage, currentSize);
                });
        });

    });
});