$(function() {
	var defaultPage = 0;
	var defaultSize = 10;
	var currentPage = defaultPage;
	var currentSize = defaultSize;
	var tableFirstLoad = true;

	layui.use(["form", "table", "laypage", "layer"], function() {
		var table = layui.table;
		var laypage = layui.laypage;
		var layer = layui.layer;
		var title = $("#realName");
		var searchTitleKey = "";

		function loadalgorithm(page, size, searchTitle) {
			if (page === null || page === undefined) page = defaultPage;
			if (size === null || size === undefined) size = defaultSize;
			var tableOption = {
				elem: "#algorithm",
				height: "full-81",
				limit: size,
				cols: [
					[{
							type: "checkbox"
						},

						{
							field: "algorithm_type",
							title: "算法类别",
							align: "center",
							width: 200,
						},
						{
							field: "algorithm_name",
							title: "算法名称",
							align: "center"
						},
						{
							field: "algorithm_format",
							title: "调用格式",
							align: "center"
						},
						{
							field: "device_name",
							title: "元气件名称",
							align: "center"
						},
						{
							field: "create_time",
							title: "创建时间",
							align: "center"
						},
						{
							field: "algorithm_path",
							title: "算法地址",
							align: "center"
						},
						{
							field: "remarks",
							title: "备注",
							align: "center"
						},
						{
							fixed: "right",
							title: "操作",
							width: 265,
							toolbar: "#operationToolbar",
							align: "center"
						}
					]
				]
			};

			if (searchTitle === null || searchTitle === undefined || searchTitle === "") {
				fetchJSON("api/algorithm/listpage?page=" + (page + 1) + "&size=" + size, {}, "get",
					function(data) {
						if (data.status === 0) {
							if (tableFirstLoad) {
								tableFirstLoad = false;
								laypage.render({
									curr: page + 1,
									elem: "pagination",
									count: data.data.total,
									layout: ["count", "prev", "page", "next", "limit",
										"refresh", "skip"
									],
									jump: function(obj, first) {
										if (first) return;
										currentPage = obj.curr - 1;
										currentSize = obj.limit;
										loadalgorithm(currentPage, currentSize,
											searchTitleKey);
									}
								});
							}

							tableOption.data = data.data.list;
							table.render(tableOption);
						} else {
							showMsg(data.msg, 2, 2000);
						}
					});
			}


		}

		loadalgorithm();

		$("#searchArticle").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			searchTitleKey = title.val().trim();
			if (searchTitleKey === "")
				loadalgorithm(0, currentSize);
			else
				loadalgorithm(0, currentSize, searchTitleKey);
		});


		$("#keyword").on("keyup", function(e) {
			e.preventDefault();
			if (e.keyCode === 13) {
				$("#searchArticle").click();
			}
		});

		// 监听表内工具条
		table.on("tool(algorithm)", function(obj) {
			var data = obj.data;
			if (obj.event === "edit") {
				// 打开编辑框 进行详细编辑
				x_admin_show(
					"编辑",
					encodeURI(
						"../admin/algorithm-add.html?id=" + data.id + "&algorithm_type=" +
						data.algorithm_type + "&algorithm_name=" + data.algorithm_name +
						"&algorithm_format=" + data.algorithm_format + "&device_name=" +
						data.device_name + "&create_time=" + data.create_time +
						"&algorithm_path=" + data.algorithm_path + "&remarks=" + data
						.remarks
					),
					468,
					560,
					function() {
						loadalgorithm(currentPage, currentSize);
					}
				);
			} else if (obj.event === "delete") {
				// 删除
				var ids = [];
				ids.push(data.id);
				layer.confirm("确认要删除吗？", function() {
					fetchJSON("api/algorithm/delete", {
						ids: ids
					}, "post", function(data) {
						if (data.status === 0) {
							showMsg("已删除!", 1, 2000);
							tableFirstLoad = true;
							loadalgorithm(currentPage, currentSize);
						} else {
							showMsg(data.msg, 2, 2000);
						}
					});
				});
			}
		});
		// 批量删除
		$("#batchDelete").on("click", function(e) {
			e.preventDefault();
			var checkedData = table.checkStatus("algorithm").data;
			if (checkedData.length === 0) {
				showMsg("未选择需要删除的日志", 2, 2000);
				return;
			}
			layer.confirm("确认要删除吗？", function() {
				var ids = [];
				for (var i = 0; i < checkedData.length; i++) {
					ids.push(checkedData[i].id);
				}

				fetchJSON("api/algorithm/delete", {
					ids: ids
				}, "post", function(data) {
					if (data.status === 0) {
						showMsg("已删除!");
						tableFirstLoad = true;
						loadalgorithm(currentPage, currentSize);
					} else {
						showMsg(data.msg, 2, 2000);
					}
				});
			});
		});
		// 新建用户
		$("#addair").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			x_admin_show("增加",
				"../admin/algorithm-add.html?id=0&algorithm_type=&algorithm_name=&algorithm_format=&device_name=&create_time=&algorithm_path=&remarks=",
				468,
				560,
				function() {
					loadalgorithm(currentPage, currentSize);
				});
		});
		
		
	});
});
