$(document).ready(function() {
  var titleControl = $("#title");
  var typeControl = $("#type");
  var typeListControl = $("#typeList");
  var dateControl = $("#date");
  var deptControl = $("#dept");
  var deptListControl = $("#deptList");
  var authorControl = $("#author");
  var authorListControl = $("#authorList");

  // 资源类型
  typeControl.on("keyup", function(e) {
    debounce(getTypeList, 200);
  });
  function getTypeList() {
    var value = typeControl.val().trim();
    if (value === "") {
      typeListControl.empty();
      return;
    }

    fetchJSON("/api/query/attrib?keyword=" + value, {}, "get", function(ret) {
        $('#loading').modal('hide');
      if (ret.code === 0) {
        typeListControl.empty();
        for (var i = 0; i < ret.data.length; i++) {
          typeListControl.append($("<option>", { value: ret.data[i].id, text: ret.data[i].name }));
        }
      } else console.log(ret.msg);
    });
  }

  // 资源日期
  layui.use("laydate", function() {
    var laydate = layui.laydate;
    laydate.render({ elem: "#date", type: "date", range: true });
  });

  // 资源单位
  deptControl.on("keyup", function(e) {
    debounce(getDeptList, 200);
  });
  function getDeptList() {
    var value = deptControl.val().trim();
    if (value === "") {
      deptListControl.empty();
      return;
    }

    fetchJSON("/api/query/dept?keyword=" + value, {}, "get", function(ret) {

      if (ret.code === 0) {
        deptListControl.empty();
        for (var i = 0; i < ret.data.length; i++) {
          deptListControl.append($("<option>", { value: ret.data[i], text: ret.data[i] }));
        }
      } else console.log(ret.msg);
    });
  }

  // 资源作者
  $("#author").on("keyup", function(e) {
    debounce(getAuthorList, 200);
  });
  function getAuthorList() {
    var value = authorControl.val().trim();
    if (value === "") {
      authorListControl.empty();
      return;
    }

    fetchJSON("/api/query/author?keyword=" + value, {}, "get", function(ret) {

      if (ret.code === 0) {
        authorListControl.empty();
        for (var i = 0; i < ret.data.length; i++) {
          authorListControl.append($("<option>", { value: ret.data[i], text: ret.data[i] }));
        }
      } else console.log(ret.msg);
    });
  }

  $("#search").on("click", function(e) {
    e.preventDefault();
    var title = titleControl.val().trim();
    var type = typeControl.val().trim();
    var date = dateControl.val().trim();
    var dept = deptControl.val().trim();
    var author = authorControl.val().trim();
    if (title === "" && type === "" && date === "" && dept === "" && author === "") {
      titleControl.focus();
      return;
    }

    window.location.href =
      "list_class.html?n=" +
      encodeURIComponent(title) +
      "&t=" +
      encodeURIComponent(type) +
      "&d=" +
      encodeURIComponent(date) +
      "&e=" +
      encodeURIComponent(dept) +
      "&a=" +
      encodeURIComponent(author);
  });
});
