$(function() {
    var defaultPage = 0;
    var defaultSize = 10;
    var currentPage = defaultPage;
    var currentSize = defaultSize;
    var tableFirstLoad = true;

    layui.use(["form", "table", "laypage", "layer", 'upload', ], function() {
        var table = layui.table;
        var laypage = layui.laypage;
        var layer = layui.layer;
        var upload = layui.upload;

        var title = $("#realName");
        var searchTitleKey = "";
        var storage = window.localStorage;

        function loadLogList(page, size, searchTitle) {
            if (page === null || page === undefined) page = defaultPage;
            if (size === null || size === undefined) size = defaultSize;

            var tableOption = {
                elem: "#logList",
                height: "full-81",
                limit: size,
                cols: [
                    [{
                            type: "checkbox"
                        },
                        {
                            field: "title",
                            title: "标题",
                            align: "center"
                        },
                        {
                            field: "author",
                            title: "作者",
                            align: "center"
                        },
                        {
                            field: "input_time",
                            title: "输入时间",
                            align: "center"
                        },
                        {
                            field: "keywords",
                            title: "关键词",
                            align: "center"
                        },
                        {
                            field: "aircraft",
                            title: "机型",
                            align: "center"
                        },
                        {
                            field: "aircraft_system",
                            title: "系统",
                            align: "center"
                        },
						{
						    field: "major_name",
						    title: "专业",
						    align: "center"
						},
                        {
                            field: "article_number",
                            title: "文章数量",
                            align: "center"
                        },
                       

                        {
                            field: "article_type",
                            title: "文章类型",
                            align: "center"
                        },
                        // {
                        //     field: "file_path",
                        //     title: "文件路径",
                        //     align: "center",
                        // },
                        {
                            fixed: "right",
                            title: "操作",
                            width: 200,
                            toolbar: "#operationToolbar",
                            align: "center"
                        }
                    ]
                ]
            };
            var articleType = "技术通报"
            if (searchTitle === null || searchTitle === undefined || searchTitle === "") {
                url = "api/article/searchArticleType?articleType=" + articleType + "&page=" + (page + 1) + " &size=" + size;
                fetchJSON(url, {}, "get", function(data) {
                    if (data.status === 0) {
                        if (tableFirstLoad) {
                            tableFirstLoad = false;
                            laypage.render({
                                curr: page + 1,
                                elem: "pagination",
                                count: data.data.total,
                                layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
                                jump: function(obj, first) {
                                    if (first) return;
                                    currentPage = obj.curr - 1;
                                    currentSize = obj.limit;
                                    loadLogList(currentPage, currentSize, searchTitleKey);
                                }
                            });
                        }
                        tableOption.data = data.data.list;
                        table.render(tableOption);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            } else {
                var url = "api/article/listByKey?keyWords=" + searchTitle + "&page=" + (page + 1) + "&size=" + size;
                fetchJSON(url, {}, "get", function(data) {
                    if (data.status === 0) {
                        if (tableFirstLoad) {
                            tableFirstLoad = false;
                            laypage.render({
                                curr: page + 1,
                                elem: "pagination",
                                count: data.data.total,
                                layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
                                jump: function(obj, first) {
                                    if (first) return;
                                    currentPage = obj.curr - 1;
                                    currentSize = obj.limit;
                                    loadLogList(currentPage, currentSize, searchTitleKey);
                                }
                            });
                        }
                        tableOption.data = data.data.list;
                        table.render(tableOption);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            }
        }

        loadLogList();

        $("#searchArticle").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            searchTitleKey = title.val().trim();
            if (searchTitleKey === "")
                loadLogList(0, currentSize);
            else
                loadLogList(0, currentSize, searchTitleKey);
        });

        $("#keyword").on("keyup", function(e) {
            e.preventDefault();
            if (e.keyCode === 13) {
                $("#searchArticle").click();
            }
        });

        // 监听表内工具条
        table.on("tool(logList)", function(obj) {
            var data = obj.data;
            if (obj.event === "delete") {
                var id = data.id
                layer.confirm("确认要删除吗？", function() {
                    fetchJSON("api/article/delete?id=" + id, {}, "post", function(data) {
                        if (data.status === 0) {
                            showMsg("已删除!");
                            tableFirstLoad = true;
                            loadLogList(currentPage, currentSize);
                        } else {
                            showMsg(data.msg, 2, 2000);
                        }
                    });
                });

            } else
            if (obj.event === "edit") {

                var dataflie = data.file_path;
                // var dataflie = "\source\1614821180657保密协议.docx"
                // flie = urlBase + dataflie

                fetchJSON("api/article/browse", { filepath: dataflie }, "get", function(d) {
                    if (d.status === 0) {
                        sessionStorage.setItem("url", d.msg)
                        x_admin_show(
                            "在线查看",
                            encodeURI(
                                "../admin/article-look.html"
                            ),
                            1300,
                            600,
                            function() {
                                loadLogList(currentPage, currentSize);
                            }
                        );
                    }
                });

            }
            if (obj.event === "replace") {

            }
        });

        // 批量删除
        $("#batchDelete").on("click", function(e) {
            e.preventDefault();
            var checkedData = table.checkStatus("logList").data;
            if (checkedData.length === 0) {
                showMsg("未选择需要删除的日志", 2, 2000);
                return;
            }
            layer.confirm("确认要删除吗？", function() {
                var ids = [];
                for (var i = 0; i < checkedData.length; i++) {
                    ids.push(checkedData[i].id);
                }

                fetchJSON("api/article/deleteByIds", { ids: ids }, "post", function(data) {
                    if (data.status === 0) {
                        showMsg("已删除!");
                        tableFirstLoad = true;
                        loadLogList(currentPage, currentSize);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });

            });
        });

        //上传
        $("#uploading").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            x_admin_show("上传文件",
                "../admin/article-add.html?title=&author=&input_time=&keywords=&description=&major_id=&major_name=&article_type=",
                800, 450,
                function() {
                    loadLogList(currentPage, currentSize);
                });
        });

    });
});