$(function() {
    var defaultPage = 0;
    var defaultSize = 10;
    var currentPage = defaultPage;
    var currentSize = defaultSize;
    var tableFirstLoad = true;

    Date.prototype.Format = function(fmt) {
        var o = {
            "M+": this.getMonth() + 1, //月份
            "d+": this.getDate(), //日
            "h+": this.getHours(), //小时
            "m+": this.getMinutes(), //分
            "s+": this.getSeconds(), //秒
            "q+": Math.floor((this.getMonth() + 3) / 3), //季度
            "S": this.getMilliseconds() //毫秒
        };
        if (/(y+)/.test(fmt))
            fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
        for (var k in o)
            if (new RegExp("(" + k + ")").test(fmt))
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
        return fmt;
    };

    function formatDate(t) {
        var now = new Date(t),
            y = now.getFullYear(),
            m = now.getMonth() + 1,
            d = now.getDate();
        return y + "-" + (m < 10 ? "0" + m : m) + "-" + (d < 10 ? "0" + d : d) + " " + now.toTimeString().substr(0, 8);
    }
    layui.use(["form", "table", "laypage", "layer"], function() {
        var table = layui.table;
        var laypage = layui.laypage;
        var layer = layui.layer;
        var title = $("#realName");
        var searchTitleKey = "";

        function loadDepartmentList(page, size, searchTitle) {
            if (page === null || page === undefined) page = defaultPage;
            if (size === null || size === undefined) size = defaultSize;
            var tableOption = {
                elem: "#departmentList",
                height: "full-81",
                limit: size,
                cols: [
                    [{
                            type: "checkbox"
                        },
                        {
                            field: "departmentName",
                            title: "部门名称",
                            align: "center"
                        },
                        {
                            field: "masterName",
                            title: "负责人名称",
                            align: "center"
                        },
                        {
                            field: "parentName",
                            title: "上级部门名称",
                            align: "center"
                        },
                        {
                            field: "remark",
                            title: "备注",
                            align: "center"
                        },
                        {
                            fixed: "right",
                            title: "操作",
                            width: 150,
                            toolbar: "#operationToolbar",
                            align: "center"
                        }
                    ]
                ]
            };


            // var url = ;
			var departmentType = 0;
			var parentId = 0;
            if (searchTitle === null || searchTitle === undefined || searchTitle === "") {
                
                fetchJSON("api/department/listpage?page=" + (page + 1) + "&size=" + size + "&departmentType=" + departmentType + "&parentId=" + parentId, {}, "get", function(data) {
                    if (data.status === 0) {
                        if (tableFirstLoad) {
                            tableFirstLoad = false;
                            laypage.render({
                                curr: page + 1,
                                elem: "pagination",
                                count: data.data.total,
                                layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
                                jump: function(obj, first) {
                                    if (first) return;
                                    // 分页控件index由1开始 后端分页index由0开始
                                    currentPage = obj.curr - 1;
                                    currentSize = obj.limit;
                                    loadDepartmentList(currentPage, currentSize, searchTitleKey);
                                }
                            });
                        }
                        tableOption.data = data.data.list;
                        table.render(tableOption);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            } else {
                fetchJSON("api/department/getByName?name=" + searchTitle, {}, "get", function(data) {
                    if (data.status === 0) {
                        if (tableFirstLoad) {
                            tableFirstLoad = false;
                            laypage.render({
                                curr: page + 1,
                                elem: "pagination",
                                count: data.data.length,
                                layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
                                jump: function(obj, first) {
                                    if (first) return;
                                    // 分页控件index由1开始 后端分页index由0开始
                                    currentPage = obj.curr - 1;
                                    currentSize = obj.limit;
                                    loadDepartmentList(currentPage, currentSize, searchTitleKey);
                                }
                            });
                        }
                        tableOption.data = data.data;
                        table.render(tableOption);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            }
        }

        // 首次载入页面 载入默认用户列表
        loadDepartmentList();

        $("#searchArticle").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            searchTitleKey = title.val().trim();
            if (searchTitleKey === "")
                loadDepartmentList(0, currentSize);
            else
                loadDepartmentList(0, currentSize, searchTitleKey);
        });


        $("#keyword").on("keyup", function(e) {
            e.preventDefault();
            if (e.keyCode === 13) {
                $("#searchArticle").click();
            }
        });

        // 操作栏
        // 监听表内工具条
        table.on("tool(departmentList)", function(obj) {
            var data = obj.data;

            // if (data.id === 1) {
            //     showMsg("默认部门不可操作!", 1, 2000);
            //     return;
            // }
            if (obj.event === "edit") {
                // 打开编辑框 进行详细编辑
                x_admin_show("编辑单位", encodeURI("../admin/department-edit.html?id=" + data.id + "&departmentName=" + data.departmentName + "&masterName=" + data.masterName +  "&parentName=" + data.parentName + "&remark=" + data.remark), 510, 500, function() {
                    loadDepartmentList(currentPage, currentSize);
                });
            } else if (obj.event === "delete") {
                // 删除
                var ids = [];
                ids.push(data.id);
                layer.confirm("确认要删除吗？", function() {
                    fetchJSON("api/department/delete", { ids: ids }, "post", function(data) {
                        if (data.status === 0) {
                            showMsg("已删除!", 1, 2000);
                            tableFirstLoad = true;
                            loadDepartmentList(currentPage, currentSize);
                        } else {
                            showMsg(data.msg, 2, 2000);
                        }
                    });
                });
            }
        });

        // 新建用户
        $("#addDepartment").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            x_admin_show("添加单位", "../admin/department-edit.html?id=0&departmentName=&masterName=&parentName=&remark=", 520, 500,
                function() {
                    loadDepartmentList(currentPage, currentSize);
                });
        });

        // 批量删除
        $("#batchDelete").on("click", function(e) {
            e.preventDefault();
            var checkedData = table.checkStatus("departmentList").data;
            if (checkedData.length === 0) {
                showMsg("未选择需要删除的项目", 2, 2000);
                return;
            }
            layer.confirm("确认要删除吗？", function() {
                var ids = [];
                for (var i = 0; i < checkedData.length; i++) {
                    if (checkedData[i].id === 1) {
                        showMsg("默认部门不可操作!", 1, 2000);
                        continue;
                    }
                    ids.push(checkedData[i].id);
                }
                if (ids.length < 1) return;
                fetchJSON("api/department/delete", { ids: ids }, "post", function(data) {
                    if (data.status === 0) {
                        showMsg("已删除!");
                        tableFirstLoad = true;
                        loadDepartmentList(currentPage, currentSize);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            });
        });
    });
});