$(function() {
    var defaultPage = 0;
    var defaultSize = 10;
    var currentPage = defaultPage;
    var currentSize = defaultSize;
    var tableFirstLoad = true;

    layui.use(["form", "table", "laypage", "layer"], function() {
        var table = layui.table;
        var laypage = layui.laypage;
        var layer = layui.layer;
        var title = $("#realName");
        var searchTitleKey = "";

        function loadDeviceList(page, size, searchTitle) {
            if (page === null || page === undefined) page = defaultPage;
            if (size === null || size === undefined) size = defaultSize;

            var tableOption = {
                elem: "#deviceList",
                height: "full-81",
                limit: size,
                cols: [
                    [{
                            type: "checkbox"
                        },
                        {
                            field: "aircraft_id",
                            title: "机型编号",
                            align: "center"
                        },
                        {
                            field: "aircraft_type",
                            title: "机型名称",
                            align: "center"
                        },
                        
                        {
                            field: "device_name",
                            title: "部件型号",
                            align: "center"
                        },
						{
						    field: "device_type",
						    title: "部件名称",
						    align: "center"
						},
                        {
                            field: "parent_id",
                            title: "所属单位",
                            align: "center"
                        },
                        {
                            field: "parent",
                            title: "起源",
                            align: "center"
                        },
                        {
                            field: "mark",
                            title: "备注",
                            align: "center"
                        },
                        {
                            fixed: "right",
                            title: "操作",
                            width: 180,
                            toolbar: "#operationToolbar",
                            align: "center"
                        }
                    ]
                ]
            };

            if (searchTitle === null || searchTitle === undefined || searchTitle === "") {
                var url = "api/device/listpage?page=" + (page + 1) + "&size=" + size;
                fetchJSON(url, {}, "get", function(data) {
                    if (data.status === 0) {
                        if (tableFirstLoad) {
                            tableFirstLoad = false;
                            laypage.render({
                                curr: page + 1,
                                elem: "pagination",
                                count: data.data.total,
                                layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
                                jump: function(obj, first) {
                                    if (first) return;
                                    currentPage = obj.curr - 1;
                                    currentSize = obj.limit;
                                    loadDeviceList(currentPage, currentSize, searchTitleKey);
                                }
                            });
                        }

                        tableOption.data = data.data.list;
                        table.render(tableOption);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            } else {
                var url = "api/device/getByName?name=" + searchTitle;
                fetchJSON(url, {}, "get", function(data) {
                    if (data.status === 0) {
                        if (tableFirstLoad) {
                            tableFirstLoad = false;
                            laypage.render({
                                curr: page + 1,
                                elem: "pagination",
                                count: data.data.total,
                                layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
                                jump: function(obj, first) {
                                    if (first) return;
                                    currentPage = obj.curr - 1;
                                    currentSize = obj.limit;
                                    loadDeviceList(currentPage, currentSize, searchTitleKey);
                                }
                            });
                        }
                        tableOption.data = data.data;
                        table.render(tableOption);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            }


        }

        loadDeviceList();

        $("#searchArticle").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            searchTitleKey = title.val().trim();
            if (searchTitleKey === "")
                loadDeviceList(0, currentSize);
            else
                loadDeviceList(0, currentSize, searchTitleKey);
        });


        $("#keyword").on("keyup", function(e) {
            e.preventDefault();
            if (e.keyCode === 13) {
                $("#searchArticle").click();
            }
        });

        // 监听表内工具条
        table.on("tool(deviceList)", function(obj) {
            var data = obj.data;
            if (obj.event === "edit") {
                // 打开编辑框 进行详细编辑
                x_admin_show(
                    "编辑",
                    encodeURI(
                        "../admin/device-edit.html?id=" + data.id + "&aircraft_id=" + data.aircraft_id + "&aircraft_type=" + data.aircraft_type +
                        "&device_name=" + data.device_name + "&device_type=" + data.device_type +  "&parent_id=" + data.parent_id  +
                        "&parent=" + data.parent + "&mark=" + data.mark
                    ),
                    800,
                    400,
                    function() {
                        loadDeviceList(currentPage, currentSize);
                    }
                );
            } else if (obj.event === "delete") {
                // 删除
                var ids = [];
                ids.push(data.id);
                layer.confirm("确认要删除吗？", function() {
                    fetchJSON("api/device/delete", {
                        ids: ids
                    }, "post", function(data) {
                        if (data.status === 0) {
                            showMsg("已删除!", 1, 2000);
                            tableFirstLoad = true;
                            loadDeviceList(currentPage, currentSize);
                        } else {
                            showMsg(data.msg, 2, 2000);
                        }
                    });
                });
            }
        });
        // 批量删除
        $("#batchDelete").on("click", function(e) {
            e.preventDefault();
            var checkedData = table.checkStatus("deviceList").data;
            if (checkedData.length === 0) {
                showMsg("未选择需要删除的日志", 2, 2000);
                return;
            }
            layer.confirm("确认要删除吗？", function() {
                var ids = [];
                for (var i = 0; i < checkedData.length; i++) {
                    ids.push(checkedData[i].id);
                }

                fetchJSON("api/device/delete", {
                    ids: ids
                }, "post", function(data) {
                    if (data.status === 0) {
                        showMsg("已删除!");
                        tableFirstLoad = true;
                        loadDeviceList(currentPage, currentSize);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            });
        });
        // 新建用户
        $("#add").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            x_admin_show("添加",
                "../admin/device-edit.html?id=0&aircraft_id=&aircraft_type=&device_name=&device_type=&mark=&parent&parent_id=",
                800, 400,
                function() {
                    loadDeviceList(currentPage, currentSize);
                });
        });

    });
});