$(function() {
	var defaultPage = 0;
	var defaultSize = 10;
	var currentPage = defaultPage;
	var currentSize = defaultSize;
	var tableFirstLoad = true;
	var tablename="faultRecord";
	Date.prototype.Format = function(fmt) {
		var o = {
			"M+": this.getMonth() + 1, //月份
			"d+": this.getDate(), //日
			"h+": this.getHours(), //小时
			"m+": this.getMinutes(), //分
			"s+": this.getSeconds(), //秒
			"q+": Math.floor((this.getMonth() + 3) / 3), //季度
			"S": this.getMilliseconds() //毫秒
		};
		if (/(y+)/.test(fmt))
			fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
		for (var k in o)
			if (new RegExp("(" + k + ")").test(fmt))
				fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
		return fmt;
	};

	function formatDate(t) {
		var now = new Date(t),
			y = now.getFullYear(),
			m = now.getMonth() + 1,
			d = now.getDate();
		return y + "-" + (m < 10 ? "0" + m : m) + "-" + (d < 10 ? "0" + d : d) + " " + now.toTimeString().substr(0, 8);
	}
	layui.config({
		base: './lib/layui_exts/'
	}).use(["form", "table", 'excel', "laypage", "layer"], function() {
		var table = layui.table;
		var laypage = layui.laypage;
		var layer = layui.layer;
		excel = layui.excel;
		var title = $("#realName");
		var searchTitleKey = "";

		function loadAirList(page, size, searchTitle) {
			if (page === null || page === undefined) page = defaultPage;
			if (size === null || size === undefined) size = defaultSize;

			var tableOption = {
				elem: "#faul",
				height: "full-81",
				limit: size,
				cols: [
					[{
							type: "checkbox"
						},
						{
							field: "dataType",
							title: "资料",
							align: "center"
						},
						{
							field: "datas",
							title: "数据",
							align: "center"
						},
						{
							field: "defaultVal",
							title: "默认值",
							align: "center"
						},
						{
							field: "len",
							title: "值",
							align: "center"
						},
						{
							field: "paramName",
							title: "变量名",
							align: "center"
						},
						{
							field: "parentName",
							title: "参数号",
							align: "center"
						},
						{
							field: "ord",
							title: "研究",
							align: "center"
						},
						{
							field: "remark",
							title: "备注",
							align: "center"
						},
						{
							fixed: "right",
							title: "操作",
							toolbar: "#operationToolbar",
							width: 200,
							align: "center"
						}
					]
				]
			};
			// var name = "1";
			fetchJSON("api/param/getTable?tableName=" + tablename, {}, "get", function(data) {
				if (data.status === 0) {
					if (tableFirstLoad) {
						tableFirstLoad = false;
						laypage.render({
							curr: page + 1,
							elem: "pagination",
							count: data.data.total,
							layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
							jump: function(obj, first) {
								if (first) return;
								currentPage = obj.curr - 1;
								currentSize = obj.limit;
								loadAirList(currentPage, currentSize);
							}
						});
					}
					tableOption.data = data.data;
					table.render(tableOption);
				} else {
					showMsg(data.msg, 2, 2000);
				}
			});
		}

		loadAirList();

		$("#searchArticle").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			searchTitleKey = title.val().trim();
			if (searchTitleKey === "")
				loadAirList(0, currentSize);
			else
				loadAirList(0, currentSize, searchTitleKey);
		});


		$("#keyword").on("keyup", function(e) {
			e.preventDefault();
			if (e.keyCode === 13) {
				$("#searchArticle").click();
			}
		});

		// 监听表内工具条
		table.on("tool(faul)", function(obj) {
			var data = obj.data;
			// 打开编辑框 进行详细编辑
			if (obj.event === "edit") {
				x_admin_show(
					"编辑",
					encodeURI(
						"../admin/faul-edit.html?id=" + data.id + "&dataType=" + data.dataType + "&datas=" + data.datas +
						"&defaultVal=" + data.defaultVal + "&len=" + data.len + "&paramName=" + data.paramName + "&parentName=" +
						data.parentName + "&ord=" + data.ord + "&remark=" + data.remark
					),
					800,
					450,
					function() {
						loadAirList(currentPage, currentSize);
					}
				);
			} else
				// 删除
				if (obj.event === "delete") {
					var ids = [];
					ids.push(data.id);
					layer.confirm("确认要删除吗？", function() {
						fetchJSON("api/param/delete", {
							ids: ids
						}, "post", function(data) {
							if (data.status === 0) {
								showMsg("已删除!", 1, 2000);
								tableFirstLoad = true;
								loadAirList(currentPage, currentSize);
							} else {
								showMsg(data.msg, 2, 2000);
							}
						});
					});
				}
		});
		//表格导出
		function exportFile(id) {

			//根据传入tableID获取表头
			var headers = layui.$("div[lay-id='faultrecord'] .layui-table-box table").get(0);
			var htrs = Array.from(headers.querySelectorAll('tr'));
			var titles = {};
			for (var j = 0; j < htrs.length; j++) {
				var hths = Array.from(htrs[j].querySelectorAll("th"));
				for (var i = 1; i < hths.length - 1; i++) {

					//排除居左、具有、隐藏字段
					//修改:默认字段data-field+i,兼容部分数据表格中不存在data-field值的问题
					titles['data-field' + i] = hths[i].innerText;
				}
			}

			根据传入tableID获取table内容
			var bodys = layui.$("div[lay-id='faultrecord'] .layui-table-box table").get(1);
			var btrs = Array.from(bodys.querySelectorAll("tr"))
			var bodysArr = new Array();
			for (var j = 0; j < btrs.length; j++) {
				var contents = {};
				var btds = Array.from(btrs[j].querySelectorAll("td"));
				for (var i = 1; i < btds.length - 1; i++) {
					for (var key in titles) {
						//修改:默认字段data-field+i,兼容部分数据表格中不存在data-field值的问题
						var field = 'data-field' + i;
						if (field === key) {
							//根据表头字段获取table内容字段
							contents[field] = btds[i].innerText;
						}
					}
				}
				bodysArr.push(contents)
			}
			//将标题行置顶添加到数组
			bodysArr.unshift(titles);
			//导出excel
			excel.exportExcel({
				sheet1: bodysArr
			}, '故障记录' + new Date().toLocaleString() + '.xlsx', 'xlsx');
		}

		$("#exportLog").on("click", function(e) {
			exportFile("faultrecord");
		});
		// 批量删除
		$("#batchDelete").on("click", function(e) {
			e.preventDefault();
			var checkedData = table.checkStatus("faultrecord").data;
			if (checkedData.length === 0) {
				showMsg("未选择需要删除的日志", 2, 2000);
				return;
			}
			layer.confirm("确认要删除吗？", function() {
				var ids = [];
				for (var i = 0; i < checkedData.length; i++) {
					ids.push(checkedData[i].id);
				}

				fetchJSON("api/param/delete", {
					ids: ids
				}, "post", function(data) {
					if (data.status === 0) {
						showMsg("已删除!");
						tableFirstLoad = true;
						loadAirList(currentPage, currentSize);
					} else {
						showMsg(data.msg, 2, 2000);
					}
				});
			});
		});
		// 新建用户
		$("#addair").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			x_admin_show("添加",
				"../admin/faul-edit.html?id=0&dataType=&datas=&defaultVal=&len=&paramName=&parentName=&ord=&remark=",
				800,
				400,
				function() {
					loadAirList(currentPage, currentSize);
				});
		});

	});
});
