var majorId = 0;
var aircraft = -1;
var major = -1;
var startTime = "";
var endTime = "";
var airNo = -1;
var systemName = -1;
$(function() {
	var myChart_s = echarts.init(document.getElementById('systemSta')); //系统分布
	var myChart_m = echarts.init(document.getElementById('majorSta')); //专业分布
	var myChart_d = echarts.init(document.getElementById('deviceSta'));//故障件分布
	var myChart_o = echarts.init(document.getElementById('optSta'));//时机分布
	var myChart_a = echarts.init(document.getElementById('airNoSta'));//机号分布


	layui.use(["form", "table", "laypage", "layer", "upload"], function() {
		var table = layui.table;
		var laypage = layui.laypage;
		var layer = layui.layer;
		var form = layui.form;
		//机型下拉框
		function getAircraft() {
			fetchJSON("api/faultrecord/getAirType", {}, "get", function(bet) {
				if (bet.status === 0) {
					$("#aircraft").empty();
					$("#aircraft").append($("<option>", {
						value: -1,
						text: "请选择机型"
					}));
					for (var i = 0; i < bet.data.length; i++) {
						if (bet.data[i].id === majorId) {
							$("#aircraft").append(
								$("<option>", {
									// value: bet.data[i].id,
									text: bet.data[i].parentName,
									selected: true
								})
							);

						} else {
							$("#aircraft").append(
								$("<option>", {
									// value: bet.data[i].id,
									text: bet.data[i].parentName
								})
							);
						}
					}
					form.render('select','aircraft');

				} else {
					showMsg(bet.msg, 2);
				}
			});

		};
		getAircraft()
		//飞机号下拉框
		function airNo(airType) {
			console.log(airType)
			fetchJSON("api/faultrecord/getAirNo?airType=" + airType, {}, "get", function(bet) {
				console.log(bet.data, "121111111")
				if (bet.status === 0) {
					$("#airNo").empty();
					$("#airNo").append($("<option>", {
						value: -1,
						text: "请选择飞机号"
					}));
					for (var i = 0; i < bet.data.length; i++) {
						if (bet.data[i].id === majorId) {
							$("#airNo").append(
								$("<option>", {
									// value: bet.data[i].id,
									text: bet.data[i].parentName,
									selected: true
								})
							);

						} else {
							$("#airNo").append(
								$("<option>", {
									// value: bet.data[i].id,
									text: bet.data[i].parentName
								})
							);
						}
					}
					form.render('select','airNo');

				} else {
					showMsg(bet.msg, 2);
				}
			});

		};

		form.on("select", function(data) {
			if (data.elem.id === "aircraft") {
				let airType = data.elem[data.elem.selectedIndex].text;
				airNo(airType);
			}
		})
		//专业下拉框


		//系统的下拉框


		//获取图表数据
		$("#sure").on("click", function() {
			startTime = $("#startTime").val().trim();
			endTime = $("#endTime").val().trim();
			major = $("#major").find("option:selected").val();
			aircraft = $("#aircraft").find("option:selected").val();
			airNo = $("#airNo").find("option:selected").text();
			systemName = $("#systemName").find("option:selected").val();
			const data = {
				airNo: airNo,
				airType: aircraft,
				department1: "",
				departmentLevle: "",
				endTme: endTime,
				major: major,
				startTime: startTime,
				systemName: systemName
			};
			$.ajax({
				type: "post",
				url: urlBase + "api/faultrecord/singleSta",
				async: true,
				data: JSON.stringify(data),
				contentType: 'application/json; charset=UTF-8',
				headers: {
					token: sessionStorage.getItem('token')
				},
				success: res => {
					if (res.status == 0) {
						var parentName = [];
						var recordCount = [];
						var data = res.data
						$('#faultCount').html(data.faultCount)
						$('#seriousCount').html(data.seriousCount)
						$("#topMajor").html(data.topMajor)
						$('#topOPT').html(data.topOPT)
						var systemSta = data.systemSta //系统
						var majorSta = data.majorSta //专业
						var deviceSta = data.deviceSta //故障件
						var optSta = data.optSta //时机
						var airNoSta = data.airNoSta //机号

						if (systemSta == null || majorSta == null || deviceSta ==
							null || optSta == null || airNoSta == null) {
							layer.msg('未找到数据');
						} else
						if (systemSta != null) { //系统分布
							var systemSta_parentName = parentName;
							var systemSta_recordCount = recordCount
							for (var i = 0; i < systemSta.length; i++) {
								systemSta_parentName.push(systemSta[i]
									.parentName)
								systemSta_recordCount.push(systemSta[i]
									.recordCount)
							}
							myCharts_s.setOption({
								title: {
									left: 'center',
									text: '系统分布'
								},
								toolbox: {
									feature: {
										saveAsImage: {
											title: '下载'
										}
									}
								},
								color: [" #29bb89"],
								xAxis: {
									type: 'category',
									// data: ['一月', '二月', '三月', '四月', '五月', '六月'],
									dta: systemSta_parentName

								},
								yAxis: {
									type: 'value',
								},
								series: [{
									// data: [1, 2, 1.5, 0.5, 1, 7],
									data: systemSta_recordCount,
									name: '搜索引擎',
									type: 'bar',
									stack: '总量',
									label: {
										show: true,
										position: 'top'
									}
								}]

							})
						} else
						if (majorSta != null) { //专业分布
							var majorSta_parentName = parentName;
							var majorSta_recordCount = recordCount
							for (var i = 0; i < majorSta.length; i++) {
								majorSta_parentName.push(majorSta[i]
									.parentName)
								majorSta_recordCount.push(majorSta[i]
									.recordCount)
							}
							myChart_m.setOption({
								title: {
									left: 'center',
									text: '专业分布'
								},
								toolbox: {
									feature: {
										saveAsImage: {
											title: '下载'
										}
									}
								},
								color: [" #29bb89"],
								xAxis: {
									type: 'category',
									// data: ['一月', '二月', '三月', '四月', '五月', '六月'],
									dta: majorSta_parentName

								},
								yAxis: {
									type: 'value',
								},
								series: [{
									// data: [1, 2, 1.5, 0.5, 1, 7],
									data: majorSta_recordCount,
									name: '搜索引擎',
									type: 'bar',
									stack: '总量',
									label: {
										show: true,
										position: 'top'
									}
								}]

							})
						} else
						if (deviceSta != null) {//故障件分布
							var deviceSta_parentName = parentName;
							var deviceSta_recordCount = recordCount
							for (var i = 0; i < deviceSta.length; i++) {
								deviceSta_parentName.push(deviceSta[i]
									.parentName)
								deviceSta_recordCount.push(deviceSta[i]
									.recordCount)
							}
							myChart_d.setOption({
								title: {
									left: 'center',
									text: '专业分布'
								},
								toolbox: {
									feature: {
										saveAsImage: {
											title: '下载'
										}
									}
								},
								color: [" #29bb89"],
								xAxis: {
									type: 'category',
									// data: ['一月', '二月', '三月', '四月', '五月', '六月'],
									dta: deviceSta_parentName

								},
								yAxis: {
									type: 'value',
								},
								series: [{
									// data: [1, 2, 1.5, 0.5, 1, 7],
									data: deviceSta_recordCount,
									name: '搜索引擎',
									type: 'bar',
									stack: '总量',
									label: {
										show: true,
										position: 'top'
									}
								}]

							})
						}else
						if (optSta != null) { //时机分布
							var optSta_parentName = parentName;
							var optSta_recordCount = recordCount
							for (var i = 0; i < optSta.length; i++) {
								optSta_parentName.push(optSta[i]
									.parentName)
								optSta_recordCount.push(optSta[i]
									.recordCount)
							}
							myChart_o.setOption({
								title: {
									left: 'center',
									text: '专业分布'
								},
								toolbox: {
									feature: {
										saveAsImage: {
											title: '下载'
										}
									}
								},
								color: [" #29bb89"],
								xAxis: {
									type: 'category',
									// data: ['一月', '二月', '三月', '四月', '五月', '六月'],
									dta: optSta_parentName
							
								},
								yAxis: {
									type: 'value',
								},
								series: [{
									// data: [1, 2, 1.5, 0.5, 1, 7],
									data: optSta_recordCount,
									name: '搜索引擎',
									type: 'bar',
									stack: '总量',
									label: {
										show: true,
										position: 'top'
									}
								}]
							
							})
						}else
						if(airNoSta != null){
							$("#table").html("<tr><td>飞机号</td><td>数量</td></tr>")
							var airNoSta_parentName = parentName;
							for (var i = 0; i < airNoSta.length; i++) {
								//表格
								var name = airNoSta[i].parentName;
								var num = airNoSta[i].parentName;
								$('#table').append("<tr><td>"+name+"</td><td>"+ num +"</td></tr>")
								//图形
								airNoSta_parentName.push({
									name : airNoSta[i].parentName,
									value : airNoSta[i].recordCount
								})
								
							}
							myChart_a.setOption({
								title: {
									text: '机号分布',
									left: 'center'
								},
								tooltip: {
									trigger: 'item'
								},
								toolbox: {
									feature: {
										saveAsImage: {
											title: '下载'
										}
									}
								},
								legend: {
									orient: 'vertical',
									left: 'left',
								},
								series: [{
									name: '访问来源',
									type: 'pie',
									radius: '50%',
									data:airNoSta_parentName,
									// data: [{
									// 		value: 800,
									// 		name: '飞机一'
									// 	},
									// 	{
									// 		value: 735,
									// 		name: '飞机二'
									// 	},
									// 	{
									// 		value: 580,
									// 		name: '飞机三'
									// 	},
									// 	{
									// 		value: 484,
									// 		name: '飞机四'
									// 	},
									// 	{
									// 		value: 300,
									// 		name: '飞机五'
									// 	}
									// ],
									emphasis: {
										itemStyle: {
											shadowBlur: 10,
											shadowOffsetX: 0,
											shadowColor: 'rgba(0, 0, 0, 0.5)'
										}
									}
								}]
							})
							
						
						}
						
						
					} else {
						alert(res.msg);
					}
				},
				error: xhr => {}
			});
		})


	});
})
