$(function() {
    var params = window.location.href.split("?");
    if (params.length > 1) {
        values = params[1].split("&");
        if (values.length > 2) {
            var funcId = values[0].replace("id=", "");
            var funcOr = "";
            var funcRk = "";

            if (funcId !== "0") {
                funcOr = decodeURI(values[1].replace("major=", ""));
                funcRk = decodeURI(values[2].replace("mark=", ""));

            }
        }
    }

    $("#major").val(funcOr);
    $("#mark").val(funcRk);
    layui.use("form", function() {
        layui.form.render();
    });

    layui.use(["form", "layer"], function() {
        $ = layui.jquery;
        var form = layui.form,
            layer = layui.layer;
        //监听提交
        form.on("submit(save)", function(data) {
            if ($("#major").val().trim() === "") {
                showMsg("专业名不能为空", 2);
                $("#major").focus();
                return false;
            }
            if ($("#mark").val().trim() === "") {
                showMsg("备注不能为空", 2);
                $("#mark").focus();
                return false;
            }
            var func = data.field;
            func.id = funcId;

            func.funcOr = $("#major").val();
            func.funcRk = $("#mark").val();
            let url = "";
            if (func.id === "0") url = "api/major/add";
            else url = "api/major/edit";
            fetchJSON(url, func, "post", function(data) {
                if (data.status === 0) {
                    var index = parent.layer.getFrameIndex(window.name);
                    showMsg("修改成功", 1, 2000);
                    parent.layer.close(index);
                } else {
                    showMsg(data.msg, 2);
                }
            });
            return false;
        });

    });
});