$(function() {
    var params = window.location.href.split("?");
    if (params.length > 1) {
        values = params[1].split("&");
        if (values.length > 4) {
            var funcId = values[0].replace("id=", "");
            var funcName = "";
            var funcUrl = "";
            var isHide = "";
            var purpose = "";
            if (funcId !== "0") {
                funcName = decodeURI(values[1].replace("rightsName=", ""));
                funcUrl = decodeURI(values[2].replace("rightsPath=", ""));
                isHide = decodeURI(values[3].replace("isHide=", ""));
                purpose = decodeURI(values[4].replace("remark=", ""));
            }
        }
    }

    $("#rightsName").val(funcName);
    $("#rightsPath").val(funcUrl);
    $("#remark").val(purpose);

    if (isHide === "0") {
        $("#isHide").attr("checked", "checked");
    }


    layui.use("form", function() {
        layui.form.render();
    });

    layui.use(["form", "layer"], function() {
        $ = layui.jquery;
        var form = layui.form,
            layer = layui.layer;
        //监听提交

        form.on("switch(isHide)", function(data) {
            console.log(data)
            isHide = data.elem.checked ? 0 : 1;
        });
        form.render('checkbox');
        form.on("submit(save)", function(data) {
            if ($("#rightsName").val().trim() === "") {
                showMsg("功能名不能为空", 2);
                $("#rightsName").focus();
                return false;
            }
            if ($("#rightsPath").val().trim() === "") {
                showMsg("功能地址不能为空", 2);
                $("#rightsPath").focus();
                return false;
            }
            var func = data.field;
            //var str = $("#hide").val()
            //func.hide = str === "on" ? 1 : 0;
            func.funcName = $("#rightsName").val();
            func.funcUrl = $("#rightsPath").val();
            func.description = $("#remark").val();
            func.id = funcId;
            func.isHide = isHide;
            let url = "";
            if (func.id === "0") url = "api/rights/add";
            else url = "api/rights/edit";
            fetchJSON(url, func, "post", function(data) {
                if (data.status === 0) {
                    var index = parent.layer.getFrameIndex(window.name);
                    showMsg("修改成功", 1, 2000);
                    parent.layer.close(index);
                } else {
                    showMsg(data.msg, 2);
                }
            });
            return false;
        });

    });
});