$(function() {
  //list_index.html?q=keyword&p=page&t=type
  var keywordControl = $("#keyword");
  var request = getRequest();

  if ((JSON.stringify(request) == "{}" || request.q === undefined) && keywordControl.val().trim() === "") {
    console.log("argument error.");
    return;
  }
  if (request.q !== undefined) keywordControl.val(request.q);

  $(".searchCategoryBarItem").removeClass("searchCategoryBarItemActive");
  if (request.t !== undefined) {
    request.t = request.t.toUpperCase();
    if (request.t === "P") $("#picture").addClass("searchCategoryBarItemActive");
    else if (request.t === "V") $("#video").addClass("searchCategoryBarItemActive");
    else if (request.t === "A") $("#audio").addClass("searchCategoryBarItemActive");
    else if (request.t === "D") $("#document").addClass("searchCategoryBarItemActive");
    else {
      request.t = "O";
      $("#other").addClass("searchCategoryBarItemActive");
    }
  } else {
    request.t = "D";
    $("#document").addClass("searchCategoryBarItemActive");
  }

  executeSearch(keywordControl, request.t, request.p);

  $("#search").on("click", function(e) {
    e.preventDefault();
    var inputValue = keywordControl.val().trim();
    if (inputValue === "" || inputValue.replace(/[-_—]/g, "") === "") {
      keywordControl.focus();
      return;
    }
    var keylist = encodeURIComponent(inputValue);
    window.location.href = "list_index.html?q=" + keylist + (request.t === undefined ? "" : "&t=" + request.t);
  });

  $("#keyword").on("keyup", function(e) {
    e.preventDefault();
    if (e.keyCode === 13) {
      $("#search").click();
    }
  });

  $(".searchCategoryBarItem").on("click", function(e) {
    e.preventDefault();
    if ($(this).attr("data-id") === request.t) return;
    $(".searchCategoryBarItem").removeClass("searchCategoryBarItemActive");
    $(this).addClass("searchCategoryBarItemActive");
    var inputValue = keywordControl.val().trim();
    if (inputValue === "" || inputValue.replace(/[-_—]/g, "") === "") {
      keywordControl.focus();
      return;
    }
    var keylist = encodeURIComponent(inputValue);
    window.location.href = "list_index.html?q=" + keylist + "&t=" + $(this).attr("data-id");
  });

  function executeSearch(control, type, page, size) {
    if (control.val().trim() === "") {
      control.focus();
      return;
    }
    if (page === null || page === undefined || page === "") page = 0;
    if (size === null || size === undefined || size === "") size = 10;
    if (type === null || type === undefined || type === "") type = "D";

    var udata = combineKeysToArray(control.val().trim());
      $('#loading').modal('show');
    fetchJSON("/api/query/query", { keyword: udata, type: type, page: page, size: size }, "post", function(ret) {
        $('#loading').modal('hide');
      if (ret.code === 0) {
        fillQueryList(udata, ret.data, type, page, $("#searchResult"), $("#totalElements"));
      } else {
        console.log(ret.msg);
      }
    });

    fetchJSON("/api/query/related", { keyword: udata }, "post", function(ret) {
      if (ret.code === 0) {
        fillRelatedKeywordList(ret.data, type, $("#relatedSearch"));
      } else {
        console.log(ret.msg);
      }
    });
  }

    setTimeout(function (){
        if (sessionStorage.getItem("userId") > 0)
        {
            $("#loginMenu").text("退出");

        }

        if (sessionStorage.getItem("userId") == 1)
        {
            $("#adminPage").show();
        }

    }, 700)
});
