$(function () {
    var request = getRequest();
    if (
        JSON.stringify(request) == "{}" ||
        request.id === undefined ||
        request.q === undefined ||
        request.t === undefined
    ) {
        console.log("argument error.");
        return;
    }

    var keywordControl = $("#keyword");
    var currentPage = 0;
    var maxPage = -1;

    if (request.q !== undefined) keywordControl.val(request.q);
    $("#search").on("click", function (e) {
        e.preventDefault();
        var inputValue = keywordControl.val().trim();
        if (inputValue === "" || inputValue.replace(/[-_—]/g, "") === "") {
            keywordControl.focus();
            return;
        }
        var keylist = encodeURIComponent(inputValue);
        window.location.href = "list_index.html?q=" + keylist + (request.t === undefined ? "" : "&t=" + request.t);
    });

    $("#keyword").on("keyup", function (e) {
        e.preventDefault();
        if (e.keyCode === 13) {
            $("#search").click();
        }
    });
    $('#loading').modal('show');
    fetchJSON("/api/resource/up/view?id=" + request.id, {}, "get", function (ret) {
        $('#loading').modal('hide');
        if (ret.code !== 0) console.log(ret.msg);
    });

    fetchJSON("/api/resource/info?id=" + request.id, {}, "get", function (ret) {
        if (ret.code === 0) {
            var resource = ret.data;

            fetchJSON(
                "/api/query/query",
                {keyword: combineKeysToArray(resource.resourceName), type: request.t, page: 0, size: 10},
                "post",
                function (ret) {
                    if (ret.code === 0) {
                        if (ret.data.resources.length != 0) {
                            $("#relatedResourcesWrapper").css("display", "block");
                            fillRelatedResourceList(ret.data.resources, request.t, $("#relatedResources"), request.q);
                        }
                    } else console.log(ret.msg);
                }
            );

            $("#title").html(resource.resourceName);
            $("#department").html(resource.submitDepartment);
            $("#author").html(resource.resourceAuthor);
            $("#submitDate").html(toDateString(resource.resourceCompletionDate));
            $("#format").html(getFileExt(resource.resourceUrl));

            var starWrapper = $("<div>", {class: "star pull-left"});
            var starSpan = $("<span>", {text: "满意度："});
            starWrapper.append(starSpan);
            var b = parseInt(resource.satisfaction / 20);
            var c = resource.satisfaction % 20 == 0 ? 0 : 1;
            var rank = b + c;
            for (var j = 0; j < 5; j++) {
                if (j < rank)
                    starWrapper.append(
                        $("<span>", {
                            id: "star" + j,
                            class: "satisfaction icon cur",
                            style: "cursor: pointer;",
                            html: "&#xe644; &nbsp;"
                        })
                    );
                else
                    starWrapper.append(
                        $("<span>", {
                            id: "star" + j,
                            class: "satisfaction icon",
                            style: "cursor: pointer;",
                            html: "&#xe644; &nbsp;"
                        })
                    );
            }

            var img = $("<img>", {
                id: "player",
                width: "100%",
                height: "500px",
                src: urlBase + "/file/" + resource.resourceUrl
            });

            $("#playerWrapper").append(img);
            $("#playerWrapper")
                .append($("<br>", {id: "placeholder"}));

            fetchJSON("/api/resource/imgRelationList?id=" + resource.id, {}, "get", function (ret) {
                if (ret.code === 0) {
                    currentPage = 0;
                    maxPage = ret.data.totalPage;

                    $("<div>", {id: "imgListWrapper"}).insertAfter($("#placeholder"));
                    var originImg = $("#player").prop('src');
                    $("#imgListWrapper").append($("<h4>", {
                        id: "imgListInfo",
                        text: "相关图片(共" + ret.data.totalElement + "项 / 第" + (parseInt(currentPage, 10) + 1) + "页 / 共" + maxPage + "页 )",
                        style: "margin-top: 40px; margin-bottom: 20px; color: blue;"
                    }));
                    $("#imgListWrapper").append($("<div>", {
                        id: "imgContainer",
                        style: "height: 100px; text-align: center;"
                    }));
                    for (var i = 0; i < ret.data.content.length; i++) {
                        var img = $("<img>", {
                            src: decodeURIComponent(ret.data.content[i]),
                            style: "padding: 5px",
                            width: 100,
                            height: 80
                        });
                        img.on('click', function () {
                            $("#player").prop('src', this.src);
                        });
                        $("#imgContainer").append(img);
                    }

                    $("#imgListWrapper").append($("<div>", {id: "btnContainer", style: "text-align: center;"}));
                    $("#btnContainer").append($("<div>"))
                        .append(
                            $("<button>", {
                                id: "prevPage",
                                class: "btn btn-primary",
                                html: "上一页",
                                style: "margin: 15px;"
                            }))
                        .append(
                            $("<button>", {
                                id: "origin",
                                class: "btn btn-primary",
                                html: "原图",
                                style: "margin: 15px;"
                            }))
                        .append(
                            $("<button>", {
                                id: "nextPage",
                                class: "btn btn-primary",
                                html: "下一页",
                                style: "margin: 15px;"
                            }))
                        .append($("<br>"));

                    $('#origin').on('click', function () {
                        $("#player").prop('src', originImg);
                    });

                    $("#prevPage").on('click', function () {
                        if (currentPage > 0) {
                            currentPage--;
                            $("#imgListInfo").html("相关图片(共" + ret.data.totalElement + "项 / 第" + (parseInt(currentPage, 10) + 1) + "页 / 共" + maxPage + "页 )");
                            fetchJSON("/api/resource/imgRelationList?id=" + resource.id + "&page=" + currentPage, {}, "get", function (ret) {
                                if (ret.code === 0) {
                                    $("#imgContainer").empty();
                                    for (var i = 0; i < ret.data.content.length; i++) {
                                        var img = $("<img>", {
                                            src: decodeURIComponent(ret.data.content[i]),
                                            style: "padding: 5px",
                                            width: 100
                                        });
                                        img.on('click', function () {
                                            $("#player").prop('src', this.src);
                                        });
                                        $("#imgContainer").append(img);
                                    }
                                    $("imgListInfo").text("相关图片(共" + ret.data.totalElement + "项 / 第" + parseInt(currentPage) + 1 + "页)");

                                } else {
                                    console.log(ret.msg);
                                }

                            });
                        }
                    });

                    $("#nextPage").on('click', function () {
                        if (currentPage + 1 < maxPage) {
                            currentPage++;
                            $("#imgListInfo").html("相关图片(共" + ret.data.totalElement + "项 / 第" + (parseInt(currentPage, 10) + 1) + "页 / 共" + maxPage + "页 )");
                            fetchJSON("/api/resource/imgRelationList?id=" + resource.id + "&page=" + currentPage, {}, "get", function (ret) {
                                if (ret.code === 0) {
                                    $("#imgContainer").empty();
                                    for (var i = 0; i < ret.data.content.length; i++) {
                                        var img = $("<img>", {
                                            src: decodeURIComponent(ret.data.content[i]),
                                            style: "padding: 5px",
                                            width: 100
                                        });
                                        img.on('click', function () {
                                            $("#player").prop('src', this.src);
                                        });
                                        $("#imgContainer").append(img);
                                    }
                                } else {
                                    console.log(ret.msg);
                                }
                            });
                        }
                    });
                } else {
                    console.log(ret.msg);
                }
            });
            $("#playerWrapper")
                .append($("<h4>", {text: "可用操作", style: "margin-top: 40px; color: blue;"}))
                .append($("<hr>"))
                .append(starWrapper);


            fetchJSON("/api/resource/downloadPermission", {}, "get", function (ret) {
                if (ret.code === 0) {
                    if (ret.data === true) {
                        $("#playerWrapper").append(
                            $("<button>", {
                                id: "download",
                                class: "btn btn-primary icon pull-right",
                                download: "",
                                html: "&#xe6fe; 点击下载 (已下载" + resource.downloadTimes + "次)"
                            })
                        );
                        var times = resource.downloadTimes;
                        $("#download").on("click", function (e) {
                            downloadResource("/api/resource/download?id=" + request.id);
                            times++;
                            $("#download").html("&#xe6fe; 点击下载 (已下载" + times + "次)");
                        });
                    }
                } else {
                    console.log(ret.msg);
                }
            });


            fetchJSON("/api/user/isCollected?id="+resource.id, {},"get", function (ret) {
                if (ret.code === 0) {
                    if (ret.code === 0) {
                        $("#playerWrapper").prepend(
                            $("<button>", {
                                id: "collect",
                                class: "btn btn-primary icon pull-right",
                                html: "&#xe6fe; 点击收藏"
                            })
                        );
                        $("#collect").on("click", function (e) {
                            collectResource(resource.id, 1);
                            $("#collect").hide();
                            $("#collect1").show();
                        });
                        $("#playerWrapper").prepend(
                            $("<button>", {
                                id: "collect1",
                                class: "btn btn-danger icon pull-right",
                                html: "&#xe6fe; 取消收藏"
                            })
                        );
                        $("#collect1").on("click", function (e) {
                            collectResource(resource.id, 0);
                            $("#collect").show();
                            $("#collect1").hide();
                        });
                        if (ret.data === false) {
                            $("#collect1").hide();
                        } else {
                            $("#collect").hide();
                        }
                    } else {
                        console.log(ret.msg);
                    }
                }
            });
            //     .append(
            //         $("<button>", {
            //             id: "download",
            //             class: "btn btn-primary icon pull-right",
            //             download: "",
            //             html: "&#xe6fe; 点击下载 (已下载" + resource.downloadTimes + "次)",
            //             style: "margin-top: 5px;"
            //         })
            //     );
            // var times = resource.downloadTimes;
            // $("#download").on("click", function (e) {
            //     downloadResource("/api/resource/download?id=" + request.id);
            //     times++;
            //     $("#download").html("&#xe6fe; 点击下载 (已下载" + times + "次)");
            // });
            $(".satisfaction").hover(
                function (e) {
                    var id = this.id.replace("star", "");
                    for (var i = 0; i <= id; i++) $("#star" + i).addClass("cur");
                },
                function (e) {
                    for (var i = 0; i < 5; i++) if (i > rank - 1) $("#star" + i).removeClass("cur");
                }
            );

            $(".satisfaction").on("click", function (e) {
                var id = parseInt(this.id.replace("star", ""));
                rank = parseInt(id + 1);
                fetchJSON(
                    "/api/resource/satisfaction?id=" + resource.id + "&satisfaction=" + (parseInt(id) + 1) * 20,
                    {},
                    "post",
                    function (ret) {
                        if (ret.code !== 0) console.log(ret.msg);
                    }
                );
            });
        } else {
            console.log(ret.msg);
        }
    });

    fetchJSON("/api/query/related", {keyword: combineKeysToArray(request.q)}, "post", function (ret) {
        if (ret.code === 0) {
            if (ret.data.length != 0) {
                $("#relatedKeywordsWrapper").css("display", "block");
                fillRelatedKeywordList(ret.data, request.t, $("#relatedKeywords"));
            }
        } else {
            console.log(ret.msg);
        }
    });
});
