$(function () {
    fetchJSON("/api/user/info", {}, "get", function (data) {
        if (data.code === 0) {
            $("#username").html(
                data.data.userAccount + (data.data.realName === null ? "" : " ( " + data.data.realName + " ) ")
            );
        } else {
            console.log(data.msg);
        }
    });
    setInterval(function () {
        var time = new Date();
        $("#clock").html("当前时间：" + time.toLocaleString());
    }, 1000);

    // 角色数
    fetchJSON("/api/role/roleCount", {}, "get", function (data) {
        if (data.code === 0) {
            $("#roleCount").html(data.data);
        } else {
            console.log(data.msg);
        }
    });

    // 用户数
    fetchJSON("/api/user/userCount", {}, "get", function (data) {
        if (data.code === 0) {
            $("#userCount").html(data.data);
        } else {
            console.log(data.msg);
        }
    });
    // 资源总数
    fetchJSON("/api/resource/resourceCount", {}, "get", function (data) {
        if (data.code === 0) {
            $("#resourceCount").html(data.data);
        } else {
            console.log(data.msg);
        }
    });
    // 单位总数
    fetchJSON("/api/resource/deptCount", {}, "get", function (data) {
        if (data.code === 0) {
            $("#deptCount").html(data.data);
        } else {
            console.log(data.msg);
        }
    });
    // 作者数
    fetchJSON("/api/resource/authorCount", {}, "get", function (data) {
        if (data.code === 0) {
            $("#authorCount").html(data.data);
        } else {
            console.log(data.msg);
        }
    });
    $("a").on("click", function (e) {
        var index = parseInt($(this).attr("data-index"));
        var title = $(this).attr("data-title");
        var url = $(this).attr("data-url");
        if (url === "" || url === undefined || url === null) return;
        if (index !== null && index !== undefined && !isNaN(index)) {
            e.preventDefault();
            var indexed = parseInt(index) + 1;
            for (var i = 0; i < parent.xframe.length; i++) {
                var tabId = parent.xframe.eq(i).attr("tab-id");
                if (parseInt(tabId) === parseInt(indexed)) {
                    parent.windowTab.tabChange(parseInt(indexed));
                    return;
                }
            }
            parent.windowTab.tabAdd(title, url, parseInt(indexed));
            parent.windowTab.tabChange(parseInt(indexed));
        }
    });

    layui.use(['upload', 'layer'], function () {
        var upload = layui.upload;
        var layer = layui.layer;
        var uploadInst = upload.render({
            elem: '#loadWordFile',
            accept: 'file',
            exts: 'txt',
            auto: false,
            choose: function (obj) {
                obj.preview(function (index, file, result) {
                    var fileReader = new FileReader();
                    fileReader.readAsText(file);
                    fileReader.onload = function () {
                        $("#wordList").val(this.result);
                    };
                });
            }
        });
        $('#restoreES').on('click', function () {
            var content = $('#cmdString').val().trim().split('\n');
            if (content === "") {
                layer.msg("使用默认命令", {time: 5000});
            }
            fetchJSON("/restoreES",
                content,
                "post",
                function (ret) {
                    layer.msg(ret.data, {time: 5000});
                })

        });

        $('#saveWordFile').on('click', function () {
            if ($("#wordList").val().trim() === "") {
                layer.msg("待上传分词库内容为空。请先载入分词库文件，或在下面输入框中输入需要上传的分词。每行一词。", {time: 5000});
                return;
            }
            var content = $('#wordList').val().trim().split('\n');
            fetchJSON("/uploadWordFile",
                content,
                "post",
                function (ret) {
                    if (ret.code === 0) {
                        layer.msg('上传成功');
                    } else {
                        layer.msg('上传失败: ' + ret.msg, {time: 5000});
                    }
                })

        });
        $('#failure').on('click', function (e) {
            window.open('failure.html');
        });

        var intervalId;
        $('#checkDataIntegrity').on('click', function (e) {
            $('#checkDataInfo').css('display', 'inline');
            $('#checkDataIntegrity').addClass('layui-btn-disabled');

            intervalId = setInterval(function () {
                fetchJSON("/getCheckDataProgress", {}, "post", function (ret) {
                    $('#checkDataInfo').html('正在检查...' + ((ret.data > 1 ? 1 : ret.data) * 100).toFixed(2) + "%");
                    console.log(ret.data);
                });
            }, 1000);

            fetchJSON("/checkDataIntegrity", {}, "post", function (ret) {
                if (ret.code === 0) {
                    clearInterval(intervalId);
                    layer.msg('数据完整性检查完成');
                    $('#checkDataInfo').html('检查成功');
                    $('#checkDataIntegrity').removeClass('layui-btn-disabled');
                } else if (ret.code === 8) {
                    clearInterval(intervalId);
                    intervalId = setInterval(function () {
                        fetchJSON("/getCheckDataProgress", {}, "post", function (ret) {
                            $('#checkDataInfo').html('正在检查...' + ((ret.data > 1 ? 1 : ret.data) * 100).toFixed(2) + "%");
                            console.log(ret.data);
                            if (ret.data >= 1) {
                                clearInterval(intervalId);
                                layer.msg('数据完整性检查完成');
                                $('#checkDataIntegrity').removeClass('layui-btn-disabled');
                            }
                        });
                    }, 1000);
                } else {
                    clearInterval(intervalId);
                    layer.msg('数据完整性检查发生错误: ' + ret.msg, {time: 5000});
                    $('#checkDataInfo').html('检查失败: ' + ret.msg);
                    $('#checkDataIntegrity').removeClass('layui-btn-disabled');
                }
            });
        })
    });
});
