$(function() {
    var defaultPage = 0;
    var defaultSize = 10;
    var currentPage = defaultPage;
    var currentSize = defaultSize;
    var tableFirstLoad = true;

    layui.use(["form", "table", "laypage", "layer"], function() {
        var table = layui.table;
        var laypage = layui.laypage;
        var layer = layui.layer;
        var form = layui.form;
        var title = $("#realName");
        var searchTitleKey = "";

        function loadUserList(page, size, searchTitle) {
            if (page === null || page === undefined) page = defaultPage;
            if (size === null || size === undefined) size = defaultSize;

            var tableOption = {
                elem: "#userList",
                height: "full-81",
                limit: size,
                cols: [
                    [{
                            type: "checkbox"
                        },
                        {
                            field: "userName",
                            title: "账号",
                            align: "center"
                        },
                        {
                            field: "realName",
                            title: "姓名",
                            align: "center"
                        },
                        {
                            field: "password",
                            title: "密码",
                            align: "center"
                        },
						{
						    field: "roleName",
						    title: "角色名称",
						    align: "center"
						},
                        {
                            field: "departmentName",
                            title: "部门名称",
                            align: "center"
                        },
                        // {
                        //     field: "sex",
                        //     title: "性别",
                        //     align: "center",
                        //     templet: function(d) {
                        //         return d.sex == 0 ? "男" : "女"
                        //     }
                        // },
                        {
                            field: "isEnable",
                            title: "启用状态",
                            align: "center",
                            templet: function(d) {
                                return d.isEnable === 0 ? "启用":  "禁用"
                            }
                        },
                        // {
                        //     field: "img",
                        //     title: "头像",
                        //     align: "center"
                        // },
                        {
                            field: "remark",
                            title: "备注",
                            align: "center"
                        },
                        {
                            fixed: "right",
                            title: "操作",
                            width: 150,
                            toolbar: "#operationToolbar",
                            align: "center"
                        }
                    ]
                ]
            };
            if (searchTitle === null || searchTitle === undefined || searchTitle === "") {
                fetchJSON("api/user/listpage?departmentId=" + searchTitleKey + "&page=" + (page + 1) + "&size=" + size, {}, "get", function(data) {
                    if (data.status === 0) {
                        if (tableFirstLoad) {
                            tableFirstLoad = false;
                            laypage.render({
                                curr: page + 1,
                                elem: "pagination",
                                count: data.data.total,
                                layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
                                jump: function(obj, first) {
                                    if (first) return;
                                    // 分页控件index由1开始 后端分页index由0开始
                                    currentPage = obj.curr - 1;
                                    currentSize = obj.limit;
                                    loadUserList(currentPage, currentSize, searchTitle);
                                }
                            });
                        }
                        tableOption.data = data.data.list;
                        table.render(tableOption);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            } else {
                fetchJSON("api/user/getByName?name=" + searchTitle, {}, "get", function(data) {
                    if (data.status === 0) {
                        if (tableFirstLoad) {
                            tableFirstLoad = false;
                            laypage.render({
                                curr: page + 1,
                                elem: "pagination",
                                count: data.data.length,
                                layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
                                jump: function(obj, first) {
                                    if (first) return;
                                    // 分页控件index由1开始 后端分页index由0开始
                                    currentPage = obj.curr - 1;
                                    currentSize = obj.limit;
                                    loadUserList(currentPage, currentSize, searchTitle);
                                }
                            });
                        }
                        tableOption.data = data.data;
                        table.render(tableOption);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            }

        }

        fetchJSON("api/department/listAll", {}, "get", function(departmentList) {
            if (departmentList.status === 0) {
                $("#parentId").empty();
                $("#parentId").append($("<option>", {
                    value: -1,
                    text: "请选择单位"
                }));

                for (var i = 0; i < departmentList.data.length; i++) {

                    $("#parentId").append(
                        $("<option>", {
                            // value: departmentList.data[i].id,
                            text: departmentList.data[i].departmentName
                        })
                    );

                }
                layui.use("form", function() {
                    layui.form.render();
                });
            } else {
                showMsg(ret.msg, 2);
            }
        });




        // 首次载入页面 载入默认用户列表
        loadUserList();

        // 操作栏
        // 监听表内工具条
        table.on("tool(userList)", function(obj) {
            var data = obj.data;
            if (data.id === 1) {
                showMsg("默认用户不可操作!", 1, 2000);
                return;
            }
            if (obj.event === "edit") {
                // 打开编辑框 进行详细编辑
                x_admin_show("编辑用户", "../admin/user-edit.html?id=" + data.id, 800, 400, function() {
                    loadUserList(currentPage, currentSize);
                });
            } else if (obj.event === "delete") {
                // 删除
                var ids = [];
                ids.push(data.id);
                layer.confirm("确认要删除吗？", function() {
                    fetchJSON("api/user/delete", { ids: ids }, "post", function(data) {
                        if (data.status === 0) {
                            showMsg("已删除!");
                            tableFirstLoad = true;
                            loadUserList(currentPage, currentSize);
                        } else {
                            showMsg(data.msg, 2, 2000);
                        }
                    });
                });
            }
        });

        $("#searchArticle").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            searchTitleKey = title.val().trim();
            if (searchTitleKey === "")
                loadUserList(0, currentSize);
            else
                loadUserList(0, currentSize, searchTitleKey);
        });
        $("#keyword").on("keyup", function(e) {
            e.preventDefault();
            if (e.keyCode === 13) {
                $("#searchArticle").click();
            }
        });
        // 新建用户
        $("#addUser").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            x_admin_show("添加用户", "../admin/user-edit.html?id=0", 800, 400, function() {
                loadUserList(currentPage, currentSize);
            });
        });

        // 批量删除
        $("#batchDelete").on("click", function(e) {
            e.preventDefault();
            var checkedData = table.checkStatus("userList").data;
            if (checkedData.length === 0) {
                showMsg("未选择需要删除的项目", 2, 2000);
                return;
            }
            layer.confirm("确认要删除吗？", function() {
                var ids = [];
                for (var i = 0; i < checkedData.length; i++) {
                    if (checkedData[i].id === 1) {
                        showMsg("默认用户不可操作!", 1, 2000);
                        continue;
                    }
                    ids.push(checkedData[i].id);
                }
                if (ids.length < 1) return;
                fetchJSON("api/user/delete", { ids: ids }, "post", function(data) {
                    if (data.status === 0) {
                        showMsg("已删除!");
                        tableFirstLoad = true;
                        loadUserList(currentPage, currentSize);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            });
        });

        form.on('select(parentId)', function(e) {

            tableFirstLoad = true;
            searchTitleKey = $("#parentId").val();
            loadUserList();
        })
    });


});