var majorId = 0;
$(function() {
	var params = window.location.href.split("?");
	if (params.length > 1) {
		values = params[1].split("&");
		if (values.length > 6) {
			var funcId = values[0].replace("id=", "");
			var experiment_id = '';
			var algorithm_id = '';
			var calling_time = '';
			var predict_results = '';
			var diagnosis_results = '';
			var algorithm_path = '';
			var remarks = '';
			if (funcId !== "0") {
				experiment_id = decodeURI(values[1].replace("experiment_id=", ""));
				algorithm_id = decodeURI(values[2].replace("algorithm_id=", ""));
				calling_time = decodeURI(values[3].replace("calling_time=", ""));
				predict_results = decodeURI(values[4].replace("predict_results=", ""));
				diagnosis_results = decodeURI(values[5].replace("diagnosis_results=", ""));
				remarks = decodeURI(values[6].replace("remarks=", ""));
			}
		}
	}

	$("#experiment_id").val(experiment_id);
	$("#algorithm_id").val(algorithm_id);
	$("#calling_time").val(calling_time);
	$("#predict_results").val(predict_results);
	$("#diagnosis_results").val(diagnosis_results);
	$("#remarks").val(remarks);

	layui.use("form", function() {
		layui.form.render();
	});

	layui.use(["form", "layer", "laydate"], function() {
		$ = layui.jquery;
		var form = layui.form,
			layer = layui.layer;
		var laydate = layui.laydate;
		
		form.on("select", function(data) {
		   if (data.elem.id === "experiment_idSelect"){
			    experiment_id = data.elem[data.elem.selectedIndex].value;
		   }
		   else if (data.elem.id === "algorithm_idSelect"){
			   algorithm_id =data.elem[data.elem.selectedIndex].value;
		   }
		      
		})
		
		form.on("submit(save)", function(data) {
			var func = data.field;
			func.id = funcId;
			let url = "";
			func.experiment_id = experiment_id
			func.algorithm_id = algorithm_id
			if (func.id === "0") url = "api/algorithmCall/add";
			else url = "api/algorithmCall/edit";
			fetchJSON(url, func, "post", function(data) {
				if (data.status === 0) {
					var index = parent.layer.getFrameIndex(window.name);
					showMsg("修改成功", 1, 2000);
					parent.layer.close(index);
				} else {
					showMsg(data.msg, 2);
				}
			});
			return false;
		});

		function getexperiment_id() {
			fetchJSON("api/experiment/listAll", {}, "get", function(bet) {
				// console.log(bet, "121111111")
				if (bet.status === 0) {
					$("#experiment_idSelect").empty();
					$("#experiment_idSelect").append($("<option>", {
						value: -1,
						text: "请选择"
					}));
					for (var i = 0; i < bet.data.length; i++) {
						if (bet.data[i].id === majorId) {
							$("#experiment_idSelect").append(
								$("<option>", {
									value: bet.data[i].id,
									text: bet.data[i].experiment_name,
									selected: true
								})
							);
						} else {
							$("#experiment_idSelect").append(
								$("<option>", {
									value: bet.data[i].id,
									text: bet.data[i].experiment_name
								})
							);
						}
					}
					layui.use("form", function() {
						layui.form.render('select', 'experiment_idFilter');
					});
				} else {
					showMsg(bet.msg, 2);
				}
			});
		};
		getexperiment_id();
		function getalgorithm_id() {
			fetchJSON("api/algorithm/listAll", {}, "get", function(bet) {
				// console.log(bet, "121111111")
				if (bet.status === 0) {
					$("#algorithm_idSelect").empty();
					$("#algorithm_idSelect").append($("<option>", {
						value: -1,
						text: "请选择"
					}));
					for (var i = 0; i < bet.data.length; i++) {
						if (bet.data[i].id === majorId) {
							$("#algorithm_idSelect").append(
								$("<option>", {
									value: bet.data[i].id,
									text: bet.data[i].algorithm_name,
									selected: true
								})
							);
						} else {
							$("#algorithm_idSelect").append(
								$("<option>", {
									value: bet.data[i].id,
									text: bet.data[i].algorithm_name
								})
							);
						}
					}
					layui.use("form", function() {
						layui.form.render('select', 'algorithm_idFilter');
					});
				} else {
					showMsg(bet.msg, 2);
				}
			});
		};
		getalgorithm_id();
	});
});
