$(function() {
	var params = window.location.href.split("?");
	if (params.length > 1) {
		values = params[1].split("&");
		if (values.length > 7) {
			var funcId = values[0].replace("id=", "");
			var algorithm_type = '';
			var algorithm_name = '';
			var algorithm_format = '';
			var device_name = '';
			var create_time = '';
			var algorithm_path = '';
			var remarks = '';
			if (funcId !== "0") {
				algorithm_type = decodeURI(values[1].replace("algorithm_type=", ""));
				algorithm_name = decodeURI(values[2].replace("algorithm_name=", ""));
				algorithm_format = decodeURI(values[3].replace("algorithm_format=", ""));
				device_name = decodeURI(values[4].replace("device_name=", ""));
				create_time = decodeURI(values[5].replace("create_time=", ""));
				algorithm_path = decodeURI(values[6].replace("algorithm_path=", ""));
				remarks = decodeURI(values[7].replace("remarks=", ""));
			}
		}
	}

	$("#algorithm_type").val(algorithm_type);
	$("#algorithm_name").val(algorithm_name);
	$("#algorithm_format").val(algorithm_format);
	$("#device_name").val(device_name);
	$("#create_time").val(create_time);
	$("#algorithm_path").val(algorithm_path);
	$("#remarks").val(remarks);

	layui.use("form", function() {
		layui.form.render();
	});

	layui.use(["form", "layer","upload", "laydate"], function() {
		$ = layui.jquery;
		var form = layui.form,
			layer = layui.layer;
		var upload = layui.upload;
		
	
		form.on("submit(save)", function(data) {
			var func = data.field;
			func.id = funcId;
			let url = "";
			if (func.id === "0") url = "api/algorithm/add";
			else url = "api/algorithm/edit";
			fetchJSON(url, func, "post", function(data) {
				if (data.status === 0) {
					var index = parent.layer.getFrameIndex(window.name);
					showMsg("修改成功", 1, 2000);
					parent.layer.close(index);
				} else {
					showMsg(data.msg, 2);
				}
			});
			return false;
		});
		
		upload.render({
		    elem: '#file',
		    url: urlBase + "api/algorithm/importData",
		    accept: 'file', //普通文件
		    headers: {
		        "token": sessionStorage.getItem("token")
		    },
		    data: {},
		    // accept: 'file',
		    done: function(res) {
		        if (res.status === 0) {
					console.log(res)
		            $("#algorithm_path").val(res.msg);
		        } else
		            showMsg(res.msg, 2);
		    }
		});
		

	});
});
