$(function() {
	var defaultPage = 0;
	var defaultSize = 10;
	var currentPage = defaultPage;
	var currentSize = defaultSize;
	var tableFirstLoad = true;

	layui.use(["form", "table", "laypage", "layer"], function() {
		var table = layui.table;
		var laypage = layui.laypage;
		var layer = layui.layer;
		var title = $("#realName");
		var searchTitleKey = "";

		function loadalgorithmCall(page, size, searchTitle) {
			if (page === null || page === undefined) page = defaultPage;
			if (size === null || size === undefined) size = defaultSize;
			var tableOption = {
				elem: "#algorithmCall",
				height: "full-81",
				limit: size,
				cols: [
					[{
							type: "checkbox"
						},

						{
							field: "experiment_id",
							title: "实验id",
							align: "center",
							width: 200,
						},
						{
							field: "algorithm_id",
							title: "算法id",
							align: "center"
						},
						{
							field: "calling_time",
							title: "时间",
							align: "center"
						},
						{
							field: "predict_results",
							title: "产生结果",
							align: "center"
						},
						{
							field: "diagnosis_results",
							title: "诊断结果",
							align: "center"
						},
						{
							field: "remarks",
							title: "备注",
							align: "center"
						},
						{
							fixed: "right",
							title: "操作",
							width: 265,
							toolbar: "#operationToolbar",
							align: "center"
						}
					]
				]
			};

			if (searchTitle === null || searchTitle === undefined || searchTitle === "") {
				fetchJSON("api/algorithmCall/listpage?page=" + (page + 1) + "&size=" + size, {}, "get",
					function(data) {
						if (data.status === 0) {
							if (tableFirstLoad) {
								tableFirstLoad = false;
								laypage.render({
									curr: page + 1,
									elem: "pagination",
									count: data.data.total,
									layout: ["count", "prev", "page", "next", "limit",
										"refresh", "skip"
									],
									jump: function(obj, first) {
										if (first) return;
										currentPage = obj.curr - 1;
										currentSize = obj.limit;
										loadalgorithmCall(currentPage, currentSize,
											searchTitleKey);
									}
								});
							}

							tableOption.data = data.data.list;
							table.render(tableOption);
						} else {
							showMsg(data.msg, 2, 2000);
						}
					});
			}


		}

		loadalgorithmCall();

		$("#searchArticle").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			searchTitleKey = title.val().trim();
			if (searchTitleKey === "")
				loadalgorithmCall(0, currentSize);
			else
				loadalgorithmCall(0, currentSize, searchTitleKey);
		});


		$("#keyword").on("keyup", function(e) {
			e.preventDefault();
			if (e.keyCode === 13) {
				$("#searchArticle").click();
			}
		});

		// 监听表内工具条
		table.on("tool(algorithmCall)", function(obj) {
			var data = obj.data;
			if (obj.event === "edit") {
				// 打开编辑框 进行详细编辑
				x_admin_show(
					"编辑",
					encodeURI(
						"../admin/algorithmCall-add.html?id=" + data.id +
						"&experiment_id=" +
						data.experiment_id + "&algorithm_id=" + data.algorithm_id +
						"&calling_time=" + data.calling_time + "&predict_results=" +
						data.predict_results + "&diagnosis_results=" + data
						.diagnosis_results + "&remarks=" + data
						.remarks
					),
					468,
					520,
					function() {
						loadalgorithmCall(currentPage, currentSize);
					}
				);
			} else if (obj.event === "delete") {
				// 删除
				var ids = [];
				ids.push(data.id);
				layer.confirm("确认要删除吗？", function() {
					fetchJSON("api/algorithmCall/delete", {
						ids: ids
					}, "post", function(data) {
						if (data.status === 0) {
							showMsg("已删除!", 1, 2000);
							tableFirstLoad = true;
							loadalgorithmCall(currentPage, currentSize);
						} else {
							showMsg(data.msg, 2, 2000);
						}
					});
				});
			}
		});
		// 批量删除
		$("#batchDelete").on("click", function(e) {
			e.preventDefault();
			var checkedData = table.checkStatus("algorithmCall").data;
			if (checkedData.length === 0) {
				showMsg("未选择需要删除的日志", 2, 2000);
				return;
			}
			layer.confirm("确认要删除吗？", function() {
				var ids = [];
				for (var i = 0; i < checkedData.length; i++) {
					ids.push(checkedData[i].id);
				}

				fetchJSON("api/algorithmCall/delete", {
					ids: ids
				}, "post", function(data) {
					if (data.status === 0) {
						showMsg("已删除!");
						tableFirstLoad = true;
						loadalgorithmCall(currentPage, currentSize);
					} else {
						showMsg(data.msg, 2, 2000);
					}
				});
			});
		});
		// 新建用户
		$("#addair").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			x_admin_show("增加",
				"../admin/algorithmCall-add.html?id=0&experiment_id=&algorithm_id=&calling_time=&predict_results=&diagnosis_results=&remarks=",
				468,
				470,
				function() {
					loadalgorithmCall(currentPage, currentSize);
				});
		});

	});
});
