var myChart = echarts.init(document.querySelector(".data"));

option = {

    color: ['green'],
    tooltip: {
        trigger: 'axis',
        axisPointer: {
            type: 'cross',
            crossStyle: {
                color: '#999'
            }
        }
    },

    legend: {
        data: ['蒸发量', '平均温度']
    },
    xAxis: [{
        type: 'category',
        color: "#fff",
        data: ['方案一', '方案二', '方案三', '方案四', '方案五', '方案六', '方案七', ],
        axisPointer: {
            type: 'shadow'
        },
        axisLine: {
            lineStyle: {
                color: "rgba(255,255,255,.2)"
            }
        },
        axisLabel: {
            textStyle: {
                color: "rgba(255,255,255,.6)", //改变字体颜色
                fontSize: 12
            },

        },
    }],
    yAxis: [{
            type: 'value',
            name: '次数',
            min: 0,
            max: 10,
            interval: 1,
            axisLine: {
                lineStyle: {
                    color: "rgba(255,255,255,.2)"
                }
            },
            axisLabel: {
                textStyle: {
                    color: "rgba(255,255,255,.6)",
                    fontSize: 12
                },
                formatter: '{value}'
            }
        },
        {
            type: 'value',

            min: 0,
            max: 10,
            interval: 1,
            axisLine: {
                lineStyle: {
                    color: "rgba(255,255,255,.2)"
                }
            },
            axisLabel: {
                textStyle: {
                    color: "rgba(255,255,255,.6)",
                    fontSize: 12
                },
                formatter: '{value}'
            }
        }
    ],
    series: [{

            type: 'bar',
            barWidth: 20,
            lineStyle: {
                color: "#0184d5",
                width: 2
            },
            data: [3, 5, 4, 2, 5.6, 6.7, 5.6, ]
        },

        {

            type: 'line',
            yAxisIndex: 1,
            data: [3, 5, 4, 2, 5.6, 6.7, 5.6, ]
        }
    ]
};

myChart.setOption(option);
var hour, minute, second; //时 分 秒
hour = minute = second = 0; //初始化
var millisecond = 0; //毫秒
var int;

function Reset() //重置
{
    window.clearInterval(int);
    millisecond = hour = minute = second = 0;
    document.getElementById('timetext').value = ' 00:00:00';
}

function start() //开始
{
    int = setInterval(timer, 50);
}

function timer() //计时
{
    millisecond = millisecond + 50;
    if (millisecond >= 1000) {
        millisecond = 0;
        second = second + 1;
    }
    if (second >= 60) {
        second = 0;
        minute = minute + 1;
    }

    if (minute >= 60) {
        minute = 0;
        hour = hour + 1;
    }
    document.getElementById('timetext').value = toDub(hour) + ':' + toDub(minute) + ':' + toDub(second);

}
timer();


function stop() //暂停
{
    window.clearInterval(int);
}
//补零
function toDub(n) {
    return n < 10 ? "0" + n : "" + n;
}


$("#but").on("click", function() {
    top.location.href = "index.html"
})


var t = null;
t = setTimeout(time, 1000); //开始运行
function time() {
    clearTimeout(t); //清除定时器
    dt = new Date();
    var y = dt.getFullYear();
    var mt = dt.getMonth() + 1;
    var day = dt.getDate();
    var h = dt.getHours(); //获取时
    var m = dt.getMinutes(); //获取分
    var s = dt.getSeconds(); //获取秒
    document.querySelector(".show-time").innerHTML =
        "当前时间：" +
        y +
        "年" +
        mt +
        "月" +
        day +
        "日-" +
        h +
        "时" +
        m +
        "分" +
        s +
        "秒";
    t = setTimeout(time, 1000); //设定定时器，循环运行

}