$(function() {
    var params = window.location.href.split("?");
    var roleId = -1;
    var roleName = -1;
    var remark = -1;
    if (params.length === 2) {
        values = params[1].split("&");
        if (values.length === 3) {
            roleId = values[0].replace("id=", "");
            roleName = decodeURI(values[1].replace("roleName=", ""));
            remark = decodeURI(values[2].replace("remark=", ""));
        }
    }
    $("#roleName").val(roleName);
    $("#remark").val(remark);

    layui.use(["form", "table", "layer"], function() {
        var form = layui.form;
        var table = layui.table;
        var layer = layui.layer;

        function loadUserList() {
            var tableOption = {
                elem: "#userList",
                height: 400,
                limit: 150,
                cols: [
                    [
                        { type: "checkbox" },
                        { field: "id", title: "序号", align: "center" ,width:75},
                        { field: "rightsName", title: "角色权限", align: "center" },
                        { field: "isHave", title: "具备权限", templet: "#sw", align: "center",width:170}
                    ]
                ]
            };

            fetchJSON("api/rights/listByRole?roleId=" + roleId, {}, "get", function(data) {
                if (data.status === 0) {
                    tableOption.data = data.data;
                    table.render(tableOption);
                } else {
                    showMsg(data.msg, 2, 2000);
                }
            });
        }

        // 首次载入页面 载入默认用户列表
        loadUserList();

        $ = layui.jquery;
        //监听变化
        var p = 0;
        form.on("switch(sw)", function(data) {
            if (roleId === "0") {
                showMsg("请先保存角色后再进行权限修改！", 2, 2000);
            }
            var idt = data.elem.id;
            var hold = data.elem.checked;
            var addRights = [];
            var delRights = [];
            addRights.push(idt);
            delRights.push(idt);
            var arr = { ids: addRights, id: roleId };
            var arrdel = { ids: delRights, id: roleId };

            if (hold === true) {
                fetchJSON("api/role/addRights", arr, "post", function(data) {
                    if (data.status === 0) {}
                });
            } else if (hold === false) {
                fetchJSON("api/role/deleteRights", arrdel, "post", function(data) {
                    if (data.status === 0) {}
                });
            }
        });

        //批量打开
        $("#open").on("click", function(e) {
            e.preventDefault();
            var checkedData = table.checkStatus("userList").data;
            if (checkedData.length === 0) {
                showMsg("未选择需要开启的项目", 2, 2000);
                return;
            }
            var plArr = [];
            for (var i = 0; i < checkedData.length; i++) {
                plArr.push(checkedData[i].id);
            }
            var plopen = { ids: plArr, id: roleId };
            fetchJSON("api/role/addRights", plopen, "post", function(data) {
                if (data.status === 0) {
                    showMsg("修改成功");
                    loadUserList();
                } else {
                    showMsg(data.msg, 2, 2000);
                }
            });
        });

        //批量关闭
        $("#close").on("click", function(e) {
            e.preventDefault();
            var checkedData = table.checkStatus("userList").data;
            if (checkedData.length === 0) {
                showMsg("未选择需要关闭的项目", 2, 2000);
                return;
            }
            var plArr = [];
            for (var i = 0; i < checkedData.length; i++) {
                plArr.push(checkedData[i].id);
            }
            var plopen = { ids: plArr, id: roleId };
            fetchJSON("api/role/deleteRights", plopen, "post", function(data) {
                if (data.status === 0) {
                    showMsg("修改成功", 1, 2000);
                    loadUserList();
                } else {
                    showMsg(data.msg, 2, 2000);
                }
            });
        });
        $("#save").on("click", function(e) {
            let role = { id: roleId, roleName: $("#roleName").val(), remark: $("#remark").val() };
            fetchJSON("api/role/edit", role, "post", function(data) {
                if (data.status === 0) {
                    layer.alert("修改成功！", { icon: 6 }, function() {
                        var index = parent.layer.getFrameIndex(window.name);
                        parent.layer.close(index);
                    });
                } else {
                    showMsg(data.msg, 2);
                }
            });
        });
    });
});