var majorId = 0;
var aircraft_type = "";
var syst_name ="";
var aircraft_id = "";
var syst_id = "";
var subsys_name = "";
var subsys_id = "";
$(function() {
    var params = window.location.href.split("?");
    if (params.length > 1) {
        values = params[1].split("&");
        if (values.length > 5) {
            var funcId = values[0].replace("id=", "");
            var funcType = "";
            var funcEnd = "";
            var funcUrL = "";
            var funcIn = "";
            var funcDes = "";
			var funcdevice_type = ""
            if (funcId !== "0") {
				funcdevice_type = decodeURI(values[1].replace("device_type=", ""));
                funcType = decodeURI(values[2].replace("aircraft_type=", ""));
                funcEnd = decodeURI(values[3].replace("syst_name=", ""));
                funcUrL = decodeURI(values[4].replace("subsys_name=", ""));
                funcIn = decodeURI(values[5].replace("device_name=", ""));

            }
        }
    }

    $("#aircraft_type").val(funcType);
    $("#syst_name").val(funcEnd);
    $("#subsys_name").val(funcUrL);
    $("#device_name").val(funcIn);
	$("#device_type").val(2);

    layui.use("form", function() {
        layui.form.render();
    });

    layui.use(["form", "layer", "laydate"], function() {
        $ = layui.jquery;
        var form = layui.form,
            layer = layui.layer;
        var laydate = layui.laydate;
        laydate.render({
            elem: '#ending_time',
            isInitValue: false,
            type: 'datetime',
            trigger: "click"
        });
        laydate.render({
            elem: '#input_time',
            isInitValue: false,
            type: 'datetime',
            trigger: "click"
        });
        //监听提交

        form.on("switch(hide)", function(data) {
            isHide = data.elem.checked ? 1 : 0;
        });
		
		form.on("select", function(data) {
			if (data.elem.id === "aircraft_type") {
				aircraft_id = data.elem[data.elem.selectedIndex].value
				aircraft_type = data.elem[data.elem.selectedIndex].text;
				let airId = data.elem[data.elem.selectedIndex].value;
				getByAir(airId);
			}
			if (data.elem.id ==="syst_name"){
				syst_name = data.elem[data.elem.selectedIndex].text;
				syst_id = data.elem[data.elem.selectedIndex].value;
				let sysId = data.elem[data.elem.selectedIndex].value;
				getBySys(sysId)
			}
			if (data.elem.id === "subsys_name") {
				subsys_id = data.elem[data.elem.selectedIndex].value;
				subsys_name = data.elem[data.elem.selectedIndex].text;
			}
				
		})
		

        form.on("submit(save)", function(data) {
			if($("#aircraft_type").find("option:selected").val() == -1){
				showMsg("请选择机型", 2);
				$("#aircraft_type").focus();
				return false;
			}
			if($("#syst_name").find("option:selected").val() == -1){
				showMsg("请选择系统", 2);
				$("#syst_name").focus();
				return false;
			}
			if($("#subsys_name").find("option:selected").val() == -1){
				showMsg("请选择分系统", 2);
				$("#subsys_name").focus();
				return false;
			}
			
            if ($("#device_name").val().trim() === "") {
                showMsg("机件不能为空", 2);
                $("#device_name").focus();
                return false;
            }

            var func = data.field;


            func.id = funcId;
			func.aircraft_id= aircraft_id
			func.aircraft_type = aircraft_type;
			func.syst_name = syst_name;
			func.syst_id = syst_id;
			func.subsys_id = subsys_id;
			func.subsys_name = subsys_name
            let url = "";
            if (func.id === "0") url = "api/device/add";
            else url = "api/device/edit";
            fetchJSON(url, func, "post", function(data) {
                if (data.status === 0) {
                    var index = parent.layer.getFrameIndex(window.name);
                    showMsg("修改成功", 1, 2000);
                    parent.layer.close(index);
                } else {
                    showMsg(data.msg, 2);
                }
            });
            return false;
        });
		//系统
		function aircraft_type(){
			fetchJSON("api/aircraft/listAll", {}, "get", function(bet) {
				// console.log(bet, "121111111")
				if (bet.status === 0) {
					$("#aircraft_type").empty();
					$("#aircraft_type").append($("<option>", {
						value: -1,
						text: "请选择机型"
					}));
					for (var i = 0; i < bet.data.length; i++) {
						if (bet.data[i].id === majorId) {
							$("#aircraft_type").append(
								$("<option>", {
									value: bet.data[i].id,
									text: bet.data[i].aircraft_type,
									selected: true
								})
							);
						} else {
							$("#aircraft_type").append(
								$("<option>", {
									value: bet.data[i].id,
									text: bet.data[i].aircraft_type
								})
							);
						}
					}
					form.render('select');
				} else {
					showMsg(bet.msg, 2);
				}
			});
		}
		aircraft_type()
		//分系统
		function getByAir(airId){
			var deviceType = 0
			fetchJSON("api/device/getByAir?airId=" + airId +"&deviceType=" + deviceType, {}, "get", function(bet) {
				
				if (bet.status === 0) {
					$("#syst_name").empty();
					$("#syst_name").append($("<option>", {
						value: -1,
						text: "请选择系统"
					}));
					for (var i = 0; i < bet.data.length; i++) {
						if (bet.data[i].id === majorId) {
							$("#syst_name").append(
								$("<option>", {
									value: bet.data[i].id,
									text: bet.data[i].device_name,
									selected: true
								})
							);
						} else {
							$("#syst_name").append(
								$("<option>", {
									value: bet.data[i].id,
									text: bet.data[i].device_name
								})
							);
						}
					}
					form.render('select');
				} else {
					showMsg(bet.msg, 2);
				}
			});
		}
		//机件
		function getBySys(sysId) {
			var deviceType_systname = 1;
			fetchJSON("api/device/getBySys?sysId=" + sysId + "&deviceType=" + deviceType_systname, {},
				"get",
				function(bet) {
					// console.log(bet, "121111111")
					if (bet.status === 0) {
						$("#subsys_name").empty();
						$("#subsys_name").append($("<option>", {
							value: -1,
							text: "请选择分系统"
						}));
						for (var i = 0; i < bet.data.length; i++) {
							if (bet.data[i].id === majorId) {
								$("#subsys_name").append(
									$("<option>", {
										value: bet.data[i].id,
										text: bet.data[i].device_name,
										selected: true
									})
								);
							} else {
								$("#subsys_name").append(
									$("<option>", {
										value: bet.data[i].id,
										text: bet.data[i].device_name
									})
								);
							}
						}
						form.render('select');
					} else {
						showMsg(bet.msg, 2);
					}
				});
		}
	});
});