$(function() {
    var defaultPage = 0;
    var defaultSize = 10;
    var currentPage = defaultPage;
    var currentSize = defaultSize;
    var tableFirstLoad = true;

    layui.use(["form", "table", "laypage", "layer"], function() {
        var table = layui.table;
        var laypage = layui.laypage;
        var layer = layui.layer;

        function loadRoleList(page, size) {
            if (page === null || page === undefined) page = defaultPage;
            if (size === null || size === undefined) size = defaultSize;

            var tableOption = {
                elem: "#userList",
                height: "full-81",
                limit: size,
                cols: [
                    [{
                            type: "checkbox"
                        },
                        {
                            field: "roleName",
                            title: "角色名",
                            align: "center"
                        },
                        // {
                        //     field: "rights",
                        //     title: "权限",
                        //     align: "center",
                        // },
                        {
                            field: "remark",
                            title: "描述",
                            align: "center",
                        },
                        {
                            fixed: "right",
                            title: "操作",
                            toolbar: "#operationToolbar",
                            width: 330,
                            align: "center"
                        }
                    ]
                ]
            };

            var url = "api/role/listpage?page=" + (page + 1) + "&size=" + size;
            fetchJSON(url, {}, "get", function(data) {

                if (data.status === 0) {
                    if (tableFirstLoad) {
                        tableFirstLoad = false;
                        laypage.render({
                            curr: page + 1,
                            elem: "pagination",
                            count: data.data.total,
                            layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
                            jump: function(obj, first) {
                                if (first) return;
                                currentPage = obj.curr - 1;
                                currentSize = obj.limit;
                                loadRoleList(currentPage, currentSize);
                            }
                        });
                    }
                    tableOption.data = data.data.list;
                    table.render(tableOption);
                } else {
                    showMsg(data.msg, 2, 2000);
                }
            });
        }

        loadRoleList();

        // 监听表内工具条
        table.on("tool(userList)", function(obj) {
            var data = obj.data;
            // if (data.id === 1) {
            //     showMsg("默认角色不可操作!", 1, 2000);
            //     return;
            // }

            if (obj.event === "edit") {
                // 打开编辑框 进行详细编辑
                x_admin_show(
                    "角色权限管理",
                    encodeURI(
                        "../admin/role-edit.html?id=" + data.id + "&roleName=" + data.roleName + "&remark=" + data.remark
                    ),
                    900,
                    700,
                    function() {
                        loadRoleList(currentPage, currentSize);
                    }
                );
            } else if (obj.event === "delete") {
                // 删除
                // if (data.id === 2) {
                //     showMsg("默认角色不可删除!", 1, 2000);
                //     return;
                // }
                var ids = [];
                ids.push(data.id);
                layer.confirm("确认要删除吗？", function() {
                    fetchJSON("api/role/delete", {
                        ids: ids
                    }, "post", function(data) {
                        if (data.status === 0) {
                            showMsg("已删除!");
                            tableFirstLoad = true;
                            loadRoleList(currentPage, currentSize);
                        } else {
                            showMsg(data.msg, 2, 2000);
                        }
                    });
                });
            }
        });

        // 新建用户
        $("#addUser").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            x_admin_show("新建角色", "../admin/role-add.html?id=0&roleName=&remark=&rightsIds=&rights=&remark=", 480, 300, function() {
                loadRoleList(currentPage, currentSize);
            });
        });

        // 批量删除
        $("#batchDelete").on("click", function(e) {
            e.preventDefault();
            var checkedData = table.checkStatus("userList").data;
            if (checkedData.length === 0) {
                showMsg("未选择需要删除的角色", 2, 2000);
                return;
            }
            layer.confirm("确认要删除吗？", function() {
                var ids = [];
                for (var i = 0; i < checkedData.length; i++) {
                    if (checkedData[i].id === 1 || checkedData[i].id === 2) {
                        showMsg("默认角色不可操作!", 1, 2000);
                        continue;
                    }
                    ids.push(checkedData[i].id);
                }
                if (ids.length < 1) return;
                fetchJSON("api/role/delete", {
                    ids: ids
                }, "post", function(data) {
                    if (data.status === 0) {
                        showMsg("已删除!");
                        tableFirstLoad = true;
                        loadRoleList(currentPage, currentSize);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            });
        });
    });
});