var majorId = 0
var shop_id = -1;
var sousuo = 0;
let arr = [{
		id: 0,
		name: "全部搜索"
	},
	{
		id: 1,
		name: "故障名称"
	},
	{
		id: 2,
		name: "系统"
	},
	{
		id: 3,
		name: "故障描述"
	},
	{
		id: 4,
		name: "故障原因"
	},
]
$(function() {
	var defaultPage = 0;
	var defaultSize = 10;
	var currentPage = defaultPage;
	var currentSize = defaultSize;
	var tableFirstLoad = true;
	let type = ""

	layui.use(["form", "table", "laypage", "layer", "upload"], function() {
		var table = layui.table;
		var laypage = layui.laypage;
		var layer = layui.layer;
		var form = layui.form;
		var title = $("#realName");
		var searchTitleKey = "";

		function getMajorName() {
			fetchJSON("api/aircraft/listAll", {}, "get", function(bet) {
				if (bet.status === 0) {
					$("#major").empty();
					$("#major").append($("<option>", {
						value: -1,
						text: "请选择机型"
					}));
					for (var i = 0; i < bet.data.length; i++) {
						if (bet.data[i].id === majorId) {
							$("#major").append(
								$("<option>", {
									// value: bet.data[i].id,
									text: bet.data[i].aircraft_type,
									selected: true
								})
							);
						} else {
							$("#major").append(
								$("<option>", {
									// value: bet.data[i].id,
									text: bet.data[i].aircraft_type
								})
							);
						}
					}
					form.render('select');
				} else {
					showMsg(bet.msg, 2);
				}
			});
		};
		getMajorName()

		function getsou() {
			for (var i = 0; i < arr.length; i++) {
				$("#sou").append(
					$("<option>", {
						value: arr[i].id,
						text: arr[i].name
					})
				);
			}
		};
		getsou()

		function loadAirList(page, size, searchTitle) {
			if (page === null || page === undefined) page = defaultPage;
			if (size === null || size === undefined) size = defaultSize;

			var tableOption = {
				elem: "#airList",
				height: "full-81",
				limit: size,
				cols: [
					[{
							type: "checkbox"
						},
						{
							title: '序号',
							toolbar: '#index',
							align: 'center',
							width:60
						},
						{
							field: "manual_name",
							title: "故障名称",
							align: "left",
							width: 250
						},

						{
							field: "aircraft",
							title: "机型",
							align: "center"
						},
						{
							field: "manual_system",
							title: "系统",
							align: "center"
						},
						{
							field: "subsystem",
							title: "分系统",
							align: "center"
						},
						{
							field: "fault_part",
							title: "机件名称",
							align: "center"
						},
						{
							field: "major",
							title: "专业",
							align: "center"
						},
						{
							field: "fault_describe",
							title: "故障描述",
							align: "center"
						},
						{
							field: "fault_reason",
							title: "故障原因",
							align: "center"
						},
						{
							field: "repair_plan",
							title: "处置方式",
							align: "center"
						},
						{
							field: "hmc",
							title: "HMC",
							align: "center"
						},
						{
							field: "mfl",
							title: "MFL",
							align: "center"
						},
						{
							field: "pfl",
							title: "PFL",
							align: "center"
						},
						{
							field: "gmp",
							title: "GMP",
							align: "center"
						},
						{
							fixed: "right",
							title: "操作",
							width: 179,
							toolbar: "#operationToolbar",
							align: "center"
						}
					]
				]
			};


			if (searchTitle === null || searchTitle === undefined || searchTitle === "") {
				if (shop_id == -1) {
					var url = "api/repairManual/listpage?page=" + (page + 1) + "&size=" + size;
				} else {
					var url = "api/repairManual/listpageByAircraft?aircraftName=" + shop_id +
						"&size=" + size + "&page=" + (page + 1)
				}

				fetchJSON(url, {}, "get", function(data) {
					if (data.status === 0) {
						if (tableFirstLoad) {
							tableFirstLoad = false;
							laypage.render({
								curr: page + 1,
								elem: "pagination",
								count: data.data.total,
								layout: ["count", "prev", "page", "next", "limit",
									"refresh", "skip"
								],
								jump: function(obj, first) {
									if (first) return;
									currentPage = obj.curr - 1;
									currentSize = obj.limit;
									loadAirList(currentPage, currentSize,
										searchTitleKey);
								}
							});
						}
						tableOption.data = data.data.list;
						table.render(tableOption);
					} else {
						showMsg(data.msg, 2, 2000);
					}
				});

			} else {
				var url = "api/repairManual/getByKeyword?keyword=" + searchTitle + "&type=" + sousuo +
					"&size=" + size + "&page=" + (page + 1)
				fetchJSON(url, {}, "get", function(data) {
					if (data.status === 0) {
						if (tableFirstLoad) {
							tableFirstLoad = false;
							laypage.render({
								curr: page + 1,
								elem: "pagination",
								count: data.data.total,
								layout: ["count", "prev", "page", "next", "limit",
									"refresh", "skip"
								],
								jump: function(obj, first) {
									if (first) return;
									currentPage = obj.curr - 1;
									currentSize = obj.limit;
									loadAirList(currentPage, currentSize,
										searchTitleKey);
								}
							});
						}
						tableOption.data = data.data.list;
						table.render(tableOption);
					} else {
						showMsg(data.msg, 2, 2000);
					}
				});

			}

		}

		loadAirList();

		$("#searchArticle").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			searchTitleKey = title.val().trim();
			sousuo = $("#sou").find("option:selected").val();
			if (searchTitleKey === "")
				loadAirList(0, currentSize);
			else
				loadAirList(0, currentSize, searchTitleKey);
		});
		// 监听表内工具条
		table.on("tool(airList)", function(obj) {
			var data = obj.data;
			if (obj.event === "edit") {
				var dataflie = data.file_path;
				fetchJSON("api/article/browse", {
					filepath: dataflie
				}, "get", function(d) {
					if (d.status === 0) {
						sessionStorage.setItem("url", d.msg)
						x_admin_show(
							"在线查看",
							encodeURI(
								"../admin/repair.html"
							),
							1300,
							600,
							function() {
								loadAirList(currentPage, currentSize);
							}
						);

					}
				});

			} else
			if (obj.event === "delete") {
				// 删除
				var ids = [];
				ids.push(data.id);
				layer.confirm("确认要删除吗？", function() {
					fetchJSON("api/repairManual/delete", {
						ids: ids
					}, "post", function(data) {
						if (data.status === 0) {
							showMsg("已删除!", 1, 2000);
							tableFirstLoad = true;
							loadAirList(currentPage, currentSize);
						} else {
							showMsg(data.msg, 2, 2000);
						}
					});
				});
			} else
			if (obj.event === 'download') {
				var file_path = data.file_path
				var newurl = file_path.substr(1, file_path.length);
				file_path = newurl.substr(newurl.indexOf('\\') + 1, file_path.length);
				newurl = file_path.substr(0, file_path.indexOf('.'))
				newurl = urlBase + "source\\" + newurl + ".docx"
				window.open(newurl)
			} else
			if (obj.event === 'particulars') {
				var fault_describe = data.fault_describe;
				var fault_reason = data.fault_reason;
				var img_path = data.img_path;
				var repair_plan = data.repair_plan;
				sessionStorage.setItem("describe", fault_describe)
				sessionStorage.setItem("reason", fault_reason)
				sessionStorage.setItem("path", img_path)
				sessionStorage.setItem("plan", repair_plan)
				x_admin_show(
					"在线查看",
					encodeURI(
						"../admin/fault_flow_chart.html"
					),
					1300,
					600,
					function() {
						loadAirList(currentPage, currentSize);
					}
				);

			}
		});
		// 批量删除
		$("#batchDelete").on("click", function(e) {
			e.preventDefault();
			var checkedData = table.checkStatus("airList").data;
			if (checkedData.length === 0) {
				showMsg("未选择需要删除的日志", 2, 2000);
				return;
			}
			layer.confirm("确认要删除吗？", function() {
				var ids = [];
				for (var i = 0; i < checkedData.length; i++) {
					ids.push(checkedData[i].id);
				}

				fetchJSON("api/repairManual/delete", {
					ids: ids
				}, "post", function(data) {
					if (data.status === 0) {
						showMsg("已删除!");
						tableFirstLoad = true;
						loadAirList(currentPage, currentSize);
					} else {
						showMsg(data.msg, 2, 2000);
					}
				});
			});
		});
		// 新建用户
		$("#addair").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			x_admin_show("手动录入",
				"../admin/repairManual-add.html?id=0&manual_name=&fault_part=&aircraft=&manual_system=&subsystem=&manual_number=&fault_describe=&repair_plan=&file_path=&major=&fault_reason=&hmc=&mfl=&pfl=&gmp=",
				790, 650,
				function() {
					loadAirList(currentPage, currentSize);
				});
		});
		//下拉框
		$('#sure').on("click", function() {
			shop_id = $("#major").find("option:selected").val();
			// console.log(shop_id)
			tableFirstLoad = true;
			loadAirList(currentPage, currentSize);
		})
	});
});
