$(function() {
	var defaultPage = 0;
	var defaultSize = 10;
	var currentPage = defaultPage;
	var currentSize = defaultSize;
	var tableFirstLoad = true;

	layui.use(["form", "table", "laypage", "layer"], function() {
		var table = layui.table;
		var laypage = layui.laypage;
		var layer = layui.layer;
		var title = $("#realName");
		var searchTitleKey = "";

		function loaddatasource(page, size, searchTitle) {
			if (page === null || page === undefined) page = defaultPage;
			if (size === null || size === undefined) size = defaultSize;
			var tableOption = {
				elem: "#datasource",
				height: "full-81",
				limit: size,
				cols: [
					[{
							type: "checkbox"
						},

						{
							field: "source_name",
							title: "数据源名",
							align: "center",

						},
						{
							field: "source_ip",
							title: "数据源ip",
							align: "center",

						},
						{
							field: "port_number",
							title: "端口号",
							align: "center",

						},
						{
							field: "source_status",
							title: "数据源状态",
							align: "center",
							templet: function(d) {
							    return d.source_status == 0 ? "失败" : "成功"
							}
						},

						{
							fixed: "right",
							title: "操作",
							width: 265,
							toolbar: "#operationToolbar",
							align: "center"
						}
					]
				]
			};
			if (searchTitle === null || searchTitle === undefined || searchTitle === "") {
				fetchJSON("api/dataSource/listpage?page=" + (page + 1) + "&size=" + size, {}, "get",
					function(data) {
						if (data.status === 0) {
							if (tableFirstLoad) {
								tableFirstLoad = false;
								laypage.render({
									curr: page + 1,
									elem: "pagination",
									count: data.data.total,
									layout: ["count", "prev", "page", "next", "limit",
										"refresh", "skip"
									],
									jump: function(obj, first) {
										if (first) return;
										currentPage = obj.curr - 1;
										currentSize = obj.limit;
										loaddatasource(currentPage, currentSize,
											searchTitleKey);
									}
								});
							}

							tableOption.data = data.data.list;
							table.render(tableOption);
						} else {
							showMsg(data.msg, 2, 2000);
						}
					});
			} else {
				fetchJSON("api/dataSource/getByName?name=" + searchTitle , {},
					"get",
					function(data) {
						if (data.status === 0) {
							if (tableFirstLoad) {
								tableFirstLoad = false;
								laypage.render({
									curr: page + 1,
									elem: "pagination",
									count: data.data.length,
									layout: ["count", "prev", "page", "next", "limit",
										"refresh", "skip"
									],
									jump: function(obj, first) {
										if (first) return;
										currentPage = obj.curr - 1;
										currentSize = obj.limit;
										loaddatasource(currentPage, currentSize,
											searchTitleKey);
									}
								});
							}

							tableOption.data = data.data;
							table.render(tableOption);
						} else {
							showMsg(data.msg, 2, 2000);
						}
					});
			}


		}

		loaddatasource();

		$("#searchArticle").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			searchTitleKey = title.val().trim();
			if (searchTitleKey === "")
				loaddatasource(0, currentSize);
			else
				loaddatasource(0, currentSize, searchTitleKey);
		});


		$("#keyword").on("keyup", function(e) {
			e.preventDefault();
			if (e.keyCode === 13) {
				$("#searchArticle").click();
			}
		});

		// 监听表内工具条
		table.on("tool(datasource)", function(obj) {
			var data = obj.data;
			if (obj.event === "edit") {
				// 打开编辑框 进行详细编辑
				x_admin_show(
					"编辑",
					encodeURI(
						"../admin/datasource-add.html?id=" + data.id + "&source_name=" +
						data.source_name + "&source_ip=" + data.source_ip +
						"&port_number=" + data.port_number + "&source_status=" + data
						.source_status
					),
					470,
					370,
					function() {
						loaddatasource(currentPage, currentSize);
					}
				);
			} else 
			if (obj.event === "delete") {
				// 删除
				var ids = [];
				ids.push(data.id);
				layer.confirm("确认要删除吗？", function() {
					fetchJSON("api/dataSource/delete", {
						ids: ids
					}, "post", function(data) {
						if (data.status === 0) {
							showMsg("已删除!", 1, 2000);
							tableFirstLoad = true;
							loaddatasource(currentPage, currentSize);
						} else {
							showMsg(data.msg, 2, 2000);
						}
					});
				});
			}
		});
		// 批量删除
		$("#batchDelete").on("click", function(e) {
			e.preventDefault();
			var checkedData = table.checkStatus("datasource").data;
			if (checkedData.length === 0) {
				showMsg("未选择需要删除的日志", 2, 2000);
				return;
			}
			layer.confirm("确认要删除吗？", function() {
				var ids = [];
				for (var i = 0; i < checkedData.length; i++) {
					ids.push(checkedData[i].id);
				}

				fetchJSON("api/dataSource/delete", {
					ids: ids
				}, "post", function(data) {
					if (data.status === 0) {
						showMsg("已删除!");
						tableFirstLoad = true;
						loaddatasource(currentPage, currentSize);
					} else {
						showMsg(data.msg, 2, 2000);
					}
				});
			});
		});
		// 新建用户
		$("#addair").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			x_admin_show("增加",
				"../admin/datasource-add.html?id=0&source_name=&source_ip=&port_number=&source_status=",
				// "../admin/datasource-add.html?id=0",
				460,
				365,
				function() {
					loaddatasource(currentPage, currentSize);
				});
		});

	});
});
