$(function() {
	var defaultPage = 0;
	var defaultSize = 10;
	var currentPage = defaultPage;
	var currentSize = defaultSize;
	var tableFirstLoad = true;
	let type = ""

	layui.use(["form", "table", "laypage", "layer", "upload"], function() {
		var table = layui.table;
		var laypage = layui.laypage;
		var layer = layui.layer;
		var form = layui.form;
		var title = $("#realName");
		var searchTitleKey = "";

		function loadexperiment(page, size, searchTitle) {
			if (page === null || page === undefined) page = defaultPage;
			if (size === null || size === undefined) size = defaultSize;

			var tableOption = {
				elem: "#experiment",
				height: "full-81",
				limit: size,
				cols: [
					[{
							type: "checkbox"
						},
						{
							title: '序号',
							toolbar: '#index',
							align: 'center',
							width: 60
						},
						{
							field: "device_id",
							title: "元器件id",
							align: "center"
						},
						{
							field: "device_name",
							title: "元器件名称",
							align: "center"
						},
						{
							field: "experiment_name",
							title: "实验名称",
							align: "center"
						},
						{
							field: "start_time",
							title: "开始时间",
							align: "center"
						},
						{
							field: "end_time",
							title: "结束时间",
							align: "center"
						},
						{
							field: "data_type",
							title: "数据类型",
							align: "center"
						},
						{
							field: "source_id",
							title: "数据id",
							align: "center"
						},
						{
							field: "origin_data_path",
							title: "数据文件路径",
							align: "center"
						},
						{
							field: "algorithm_id",
							title: "算法id",
							align: "center"
						},
						{
							field: "algorithm_name",
							title: "算法名称",
							align: "center"
						},
						{
							field: "process_data_path",
							title: "处理数据路径",
							align: "center"
						},
						{
							fixed: "right",
							title: "操作",
							width: 179,
							toolbar: "#operationToolbar",
							align: "center"
						}
					]
				]
			};


			if (searchTitle === null || searchTitle === undefined || searchTitle === "") {
				var url = "api/experiment/listpage?page=" + (page + 1) + "&size=" + size;
				fetchJSON(url, {}, "get", function(data) {
					if (data.status === 0) {
						if (tableFirstLoad) {
							tableFirstLoad = false;
							laypage.render({
								curr: page + 1,
								elem: "pagination",
								count: data.data.total,
								layout: ["count", "prev", "page", "next", "limit",
									"refresh", "skip"
								],
								jump: function(obj, first) {
									if (first) return;
									currentPage = obj.curr - 1;
									currentSize = obj.limit;
									loadexperiment(currentPage, currentSize,
										searchTitleKey);
								}
							});
						}
						tableOption.data = data.data.list;
						table.render(tableOption);
					} else {
						showMsg(data.msg, 2, 2000);
					}
				});

			} else {
				var url = "api/experiment/getByName?name=" + searchTitle +
					"&size=" + size + "&page=" + (page + 1)
				fetchJSON(url, {}, "get", function(data) {
					if (data.status === 0) {
						if (tableFirstLoad) {
							tableFirstLoad = false;
							laypage.render({
								curr: page + 1,
								elem: "pagination",
								count: data.data.total,
								layout: ["count", "prev", "page", "next", "limit",
									"refresh", "skip"
								],
								jump: function(obj, first) {
									if (first) return;
									currentPage = obj.curr - 1;
									currentSize = obj.limit;
									loadexperiment(currentPage, currentSize,
										searchTitleKey);
								}
							});
						}
						tableOption.data = data.data;
						table.render(tableOption);
					} else {
						showMsg(data.msg, 2, 2000);
					}
				});

			}

		}

		loadexperiment();

		$("#searchArticle").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			searchTitleKey = title.val().trim();
			sousuo = $("#sou").find("option:selected").val();
			if (searchTitleKey === "")
				loadexperiment(0, currentSize);
			else
				loadexperiment(0, currentSize, searchTitleKey);
		});
		// 监听表内工具条
		table.on("tool(experiment)", function(obj) {
			var data = obj.data;
			if (obj.event === "edit") {
				// 打开编辑框 进行详细编辑
				x_admin_show(
					"编辑",
					encodeURI(
						"../admin/experiment-add.html?id=" + data.id + "&device_id=" + data
						.device_id + "&device_name=" + data.device_name +
						"&experiment_name=" + data.experiment_name + "&start_time=" + data
						.start_time + "&end_time=" + data.end_time +
						"&data_type=" + data.data_type + "&source_id=" + data.source_id +
						"&origin_data_path=" + data.origin_data_path + "&algorithm_id=" + data
						.algorithm_id+ "&algorithm_name=" + data
						.algorithm_name+ "&process_data_path=" + data
						.algorithm_name
					),
					800,
					520,
					function() {
						loadexperiment(currentPage, currentSize);
					}
				);
			} else
			if (obj.event === "delete") {
				// 删除
				var ids = [];
				ids.push(data.id);
				layer.confirm("确认要删除吗？", function() {
					fetchJSON("api/experiment/delete", {
						ids: ids
					}, "post", function(data) {
						if (data.status === 0) {
							showMsg("已删除!", 1, 2000);
							tableFirstLoad = true;
							loadexperiment(currentPage, currentSize);
						} else {
							showMsg(data.msg, 2, 2000);
						}
					});
				});
			}

		});
		// 批量删除
		$("#batchDelete").on("click", function(e) {
			e.preventDefault();
			var checkedData = table.checkStatus("experiment").data;
			if (checkedData.length === 0) {
				showMsg("未选择需要删除的日志", 2, 2000);
				return;
			}
			layer.confirm("确认要删除吗？", function() {
				var ids = [];
				for (var i = 0; i < checkedData.length; i++) {
					ids.push(checkedData[i].id);
				}

				fetchJSON("api/experiment/delete", {
					ids: ids
				}, "post", function(data) {
					if (data.status === 0) {
						showMsg("已删除!");
						tableFirstLoad = true;
						loadexperiment(currentPage, currentSize);
					} else {
						showMsg(data.msg, 2, 2000);
					}
				});
			});
		});
		// 新建用户
		$("#addair").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			x_admin_show("手动录入",
				"../admin/experiment-add.html?id=0&device_id=&device_name=&experiment_name=&start_time=&end_time=&data_type=&source_id=&origin_data_path=&algorithm_id=&algorithm_name=&process_data_path=",
				790, 520,
				function() {
					loadexperiment(currentPage, currentSize);
				});
		});
	});
});
