$(function () {
    var request = getRequest();
    if (
        JSON.stringify(request) == "{}" ||
        request.id === undefined ||
        request.q === undefined ||
        request.t === undefined
    ) {
        console.log("argument error.");
        return;
    }

    var keywordControl = $("#keyword");
    if (request.q !== undefined) keywordControl.val(request.q);
    $("#search").on("click", function (e) {
        e.preventDefault();
        var inputValue = keywordControl.val().trim();
        if (inputValue === "" || inputValue.replace(/[-_—]/g, "") === "") {
            keywordControl.focus();
            return;
        }
        var keylist = encodeURIComponent(inputValue);
        window.location.href = "list_index.html?q=" + keylist + (request.t === undefined ? "" : "&t=" + request.t);
    });

    $("#keyword").on("keyup", function (e) {
        e.preventDefault();
        if (e.keyCode === 13) {
            $("#search").click();
        }
    });
    $('#loading').modal('show');
    fetchJSON("/api/resource/up/view?id=" + request.id, {}, "get", function (ret) {
        $('#loading').modal('hide');
        if (ret.code !== 0) console.log(ret.msg);
    });

    fetchJSON("/api/resource/info?id=" + request.id, {}, "get", function (ret) {
        if (ret.code === 0) {
            var resource = ret.data;
            fetchJSON(
                "/api/query/query",
                {keyword: combineKeysToArray(resource.resourceName), type: request.t, page: 0, size: 10},
                "post",
                function (ret) {
                    if (ret.code === 0) {
                        if (ret.data.resources.length != 0) {
                            $("#relatedResourcesWrapper").css("display", "block");
                            fillRelatedResourceList(ret.data.resources, request.t, $("#relatedResources"), request.q);
                        }
                    } else console.log(ret.msg);
                }
            );

            $("#title").html(resource.resourceName);
            $("#department").html(resource.submitDepartment);
            $("#author").html(resource.resourceAuthor);
            $("#submitDate").html(toDateString(resource.resourceCompletionDate));
            $("#format").html(getFileExt(resource.resourceUrl));

            var starWrapper = $("<div>", {class: "star pull-left", style: "margin-bottom: 50px;"});
            var starSpan = $("<span>", {text: "满意度："});
            starWrapper.append(starSpan);
            var b = parseInt(resource.satisfaction / 20);
            var c = resource.satisfaction % 20 == 0 ? 0 : 1;
            var rank = b + c;
            for (var j = 0; j < 5; j++) {
                if (j < rank)
                    starWrapper.append(
                        $("<span>", {
                            id: "star" + j,
                            class: "satisfaction icon cur",
                            style: "cursor: pointer;",
                            html: "&#xe644; &nbsp;"
                        })
                    );
                else
                    starWrapper.append(
                        $("<span>", {
                            id: "star" + j,
                            class: "satisfaction icon",
                            style: "cursor: pointer;",
                            html: "&#xe644; &nbsp;"
                        })
                    );
            }

            var url = resource.resourceUrl.toLowerCase();
            var player = $("<textarea>", {
                id: "player",
                class: "form-control",
                rows: 15,
                style: "resize: none; background-color:transparent; border: 0;"
            });
            $("#playerWrapper")
                .append($("<h4>", {text: "简要内容", style: "color: blue;"}))
                .append($("<br>"))
                .append(player);

            if (url.endsWith(".doc") || url.endsWith(".docx") || url.endsWith(".xls") || url.endsWith(".xlsx") || url.endsWith(".ppt")
                || url.endsWith(".pptx") || url.endsWith(".txt") || url.endsWith(".rtf") || url.endsWith(".wps")){
                $("#playerWrapper").append($('<p>', {
                    id: "loadTips",
                    text: "正在加载预览文件，请稍候...",
                    style: "margin-top: -300px"
                }));
                fetchJSON("/api/resource/onlineView?id=" + resource.id, {}, "get", function (ret) {
                    if (ret.code === 0) {
                        $('#load' +
                            'Tips').css('display', 'none');
                        $("#playerWrapper")
                            .removeClass("col-md-10")
                            .removeClass("col-md-offset-1")
                            .addClass("col-md-12");
                        $("#playerWrapper h4").html("内容预览");
                        $("#playerWrapper h4").css('padding-left', '30px');
                        $("#player").css('display', 'none');
                       /* $("#playerWrapper")
                            .append($("<iframe>", {
                                width: $('#playerWrapper').width(),
                                height: 800,
                                src: ret.data
                            }));*/
                        $('#playerWrapper')
                            .append($("<iframe>", {
                                width: $("#playerWrapper").width(),
                                height: 800,
                                src: "/pdfjs/web/viewer.html?file=/" +ret.data
                            }));
                    } else {
                        console.log(ret.msg);
                        $('#loadTips').text('预览文件加载失败，显示默认文件概要信息');
                        player.html(resource.description);
                    }

                    $("#playerWrapper")
                        .append($("<h4>", {text: "可用操作", style: "margin-top: 40px; color: blue;"}))
                        .append($("<hr>"))
                        .append(starWrapper);

                    $(".satisfaction").hover(
                        function (e) {
                            var id = this.id.replace("star", "");
                            for (var i = 0; i <= id; i++) $("#star" + i).addClass("cur");
                        },
                        function (e) {
                            for (var i = 0; i < 5; i++) if (i > rank - 1) $("#star" + i).removeClass("cur");
                        }
                    );

                    $(".satisfaction").on("click", function (e) {
                        var id = parseInt(this.id.replace("star", ""));
                        rank = parseInt(id + 1);
                        fetchJSON(
                            "/api/resource/satisfaction?id=" + resource.id + "&satisfaction=" + (parseInt(id) + 1) * 20,
                            {},
                            "post",
                            function (ret) {
                                if (ret.code !== 0) console.log(ret.msg);
                            }
                        );
                    });

                    fetchJSON("/api/resource/downloadPermission", {}, "get", function (ret) {
                        if (ret.code === 0) {
                            if (ret.data === true) {

                                $("#playerWrapper").append(
                                    $("<button>", {
                                        id: "download",
                                        class: "btn btn-primary icon pull-right",
                                        download: "",
                                        html: "&#xe6fe; 点击下载 (已下载" + resource.downloadTimes + "次)"
                                    })
                                );
                                var times = resource.downloadTimes;
                                $("#download").on("click", function (e) {
                                    downloadResource("/api/resource/download?id=" + request.id);
                                    times++;
                                    $("#download").html("&#xe6fe; 点击下载 (已下载" + times + "次)");
                                });

                                $("#playerWrapper").append(
                                    $("<button>", {
                                        id: "download1",
                                        class: "btn btn-primary icon pull-right",
                                        style:"margin-right :10px",
                                        html: "&#xe6fe; 点击打印"
                                    })
                                );

                                $("#download1").on("click", function (e) {
                                    $('iframe:last').contents().find("#secondaryPrint").click();
                                });
                            }
                        } else {
                            console.log(ret.msg);
                        }
                    });


                    fetchJSON("/api/user/isCollected?id="+resource.id,{}, "get", function (ret) {
                        if (ret.code === 0) {
                            $("#playerWrapper").prepend(
                                $("<button>", {
                                    id: "collect",
                                    class: "btn btn-primary icon pull-right",
                                    style:"margin-right :10px",
                                    html: "&#xe6fe; 点击收藏"
                                })
                            );
                            $("#collect").on("click", function (e) {
                                collectResource(resource.id,1);
                                $("#collect").hide();
                                $("#collect1").show();
                            });
                            $("#playerWrapper").prepend(
                                $("<button>", {
                                    id: "collect1",
                                    class: "btn btn-danger icon pull-right",
                                    style:"margin-right :10px",
                                    html: "&#xe6fe; 取消收藏"
                                })
                            );
                            $("#collect1").on("click", function (e) {
                                collectResource(resource.id,0);
                                $("#collect").show();
                                $("#collect1").hide();
                            });
                            if (ret.data === false) {
                                $("#collect1").hide();
                            }else
                            {
                                $("#collect").hide();
                            }
                        } else {
                            console.log(ret.msg);
                        }
                    });
                });
            } else if (url.endsWith(".pdf")) {
                $("#playerWrapper")
                    .removeClass("col-md-10")
                    .removeClass("col-md-offset-1")
                    .removeClass("col-md-12");
                $("#playerWrapper h4").html("内容预览");
                $("#playerWrapper h4").css("padding-left", '30px');
                $("#player").css('display', 'none');
                /*$('#playerWrapper')
                    .append($("<iframe>", {
                        width: $("#playerWrapper").width(),
                        height: 800,
                        src: urlBase + "/file/" + resource.resourceUrl
                    }));*/
                $('#playerWrapper')
                    .append($("<iframe>", {
                        width: $("#playerWrapper").width(),
                        height: 800,
                        src: "/pdfjs/web/viewer.html?file=" + "/file/" + resource.resourceUrl
                    }));
                $("#playerWrapper")
                    .append($("<h4>", {text: "可用操作", style: "margin-top: 40px; color: blue;"}))
                    .append($("<hr>"))
                    .append(starWrapper);

                fetchJSON("/api/resource/downloadPermission", {}, "get", function (ret) {
                    if (ret.code === 0) {
                        if (ret.data === true) {


                            $("#playerWrapper").append(
                                $("<button>", {
                                    id: "download",
                                    class: "btn btn-primary icon pull-right",
                                    download: "",
                                    html: "&#xe6fe; 点击下载 (已下载" + resource.downloadTimes + "次)"
                                })
                            );
                            var times = resource.downloadTimes;
                            $("#download").on("click", function (e) {
                                downloadResource("/api/resource/download?id=" + request.id);
                                times++;
                                $("#download").html("&#xe6fe; 点击下载 (已下载" + times + "次)");
                            });

                            $("#playerWrapper").append(
                                $("<button>", {
                                    id: "download1",
                                    class: "btn btn-primary icon pull-right",
                                    style:"margin-right :10px",
                                    html: "&#xe6fe; 点击打印"
                                })
                            );

                            $("#download1").on("click", function (e) {
                                $('iframe:last').contents().find("#secondaryPrint").click();
                            });

                        }
                    } else {
                        console.log(ret.msg);
                    }
                });

                fetchJSON("/api/user/isCollected?id="+resource.id,{}, "get", function (ret) {
                    if (ret.code === 0) {
                        $("#playerWrapper").prepend(
                            $("<button>", {
                                id: "collect",
                                class: "btn btn-primary icon pull-right",
                                style:"margin-right :10px",
                                html: "&#xe6fe; 点击收藏"
                            })
                        );
                        $("#collect").on("click", function (e) {
                            collectResource(resource.id,1);
                            $("#collect").hide();
                            $("#collect1").show();
                        });
                        $("#playerWrapper").prepend(
                            $("<button>", {
                                id: "collect1",
                                class: "btn btn-danger icon pull-right",
                                style:"margin-right :10px",
                                html: "&#xe6fe; 取消收藏"
                            })
                        );
                        $("#collect1").on("click", function (e) {
                            collectResource(resource.id,0);
                            $("#collect").show();
                            $("#collect1").hide();
                        });
                        if (ret.data === false) {
                            $("#collect1").hide();
                        }else
                        {
                            $("#collect").hide();
                        }
                    } else {
                        console.log(ret.msg);
                    }
                });

            } else {
                player.html(resource.description);
                $("#playerWrapper")
                    .append($("<h4>", {text: "可用操作", style: "margin-top: 40px; color: blue;"}))
                    .append($("<hr>"))
                    .append(starWrapper);

                fetchJSON("/api/resource/downloadPermission", {}, "get", function (ret) {
                    if (ret.code === 0) {
                        if (ret.data === true) {
                            $("#playerWrapper").append(
                                $("<button>", {
                                    id: "download",
                                    class: "btn btn-primary icon pull-right",
                                    download: "",
                                    html: "&#xe6fe; 点击下载 (已下载" + resource.downloadTimes + "次)"
                                })
                            );
                            var times = resource.downloadTimes;
                            $("#download").on("click", function (e) {
                                downloadResource("/api/resource/download?id=" + request.id);
                                times++;
                                $("#download").html("&#xe6fe; 点击下载 (已下载" + times + "次)");
                            });
                        }
                    } else {
                        console.log(ret.msg);
                    }
                });

            fetchJSON("/api/user/isCollected?id="+resource.id,{}, "get", function (ret) {
                if (ret.code === 0) {
                    $("#playerWrapper").prepend(
                        $("<button>", {
                            id: "collect",
                            class: "btn btn-primary icon pull-right",
                            style:"margin-right :10px",
                            html: "&#xe6fe; 点击收藏"
                        })
                    );
                    $("#collect").on("click", function (e) {
                        collectResource(resource.id,1);
                        $("#collect").hide();
                        $("#collect1").show();
                    });
                    $("#playerWrapper").prepend(
                        $("<button>", {
                            id: "collect1",
                            class: "btn btn-danger icon pull-right",
                            style:"margin-right :10px",
                            html: "&#xe6fe; 取消收藏"
                        })
                    );
                    $("#collect1").on("click", function (e) {
                        collectResource(resource.id,0);
                        $("#collect").show();
                        $("#collect1").hide();
                    });
                    if (ret.data === false) {
                        $("#collect1").hide();
                    }else
                    {
                        $("#collect").hide();
                    }
                } else {
                    console.log(ret.msg);
                }
            });
            }
            $(".satisfaction").hover(
                function (e) {
                    var id = this.id.replace("star", "");
                    for (var i = 0; i <= id; i++) $("#star" + i).addClass("cur");
                },
                function (e) {
                    for (var i = 0; i < 5; i++) if (i > rank - 1) $("#star" + i).removeClass("cur");
                }
            );

            $(".satisfaction").on("click", function (e) {
                var id = parseInt(this.id.replace("star", ""));
                rank = parseInt(id + 1);
                fetchJSON(
                    "/api/resource/satisfaction?id=" + resource.id + "&satisfaction=" + (parseInt(id) + 1) * 20,
                    {},
                    "post",
                    function (ret) {
                        if (ret.code !== 0) console.log(ret.msg);
                    }
                );
            });
        } else {
            console.log(ret.msg);
        }
    });

    fetchJSON("/api/query/related", {keyword: combineKeysToArray(request.q)}, "post", function (ret) {
        if (ret.code === 0) {
            if (ret.data.length != 0) {
                $("#relatedKeywordsWrapper").css("display", "block");
                fillRelatedKeywordList(ret.data, request.t, $("#relatedKeywords"));
            }
        } else {
            console.log(ret.msg);
        }
    });
});
