$(function() {
	var defaultPage = 0;
	var defaultSize = 10;
	var currentPage = defaultPage;
	var currentSize = defaultSize;
	var tableFirstLoad = true;

	layui.use(["form", "table", "laypage", "layer"], function() {
		var table = layui.table;
		var laypage = layui.laypage;
		var layer = layui.layer;

		function loadMajorList(page, size) {
			if (page === null || page === undefined) page = defaultPage;
			if (size === null || size === undefined) size = defaultSize;

			var tableOption = {
				elem: "#majorList",
				height: "full-81",
				limit: size,
				cols: [
					[{
							type: "checkbox"
						},
						// {
						// 	field: "id",
						// 	title: "序号",
						// 	align: "center"
						// },
						{
							field: "major",
							title: "专业名",
							align: "center"
						},
						{
							field: "mark",
							title: "备注",
							align: "center"
						},
						{
							fixed: "right",
							title: "操作",
							toolbar: "#operationToolbar",
							width: 330,
							align: "center"
						}
					]
				]
			};

			var url = "api/major/listAll?page=" + (page + 1) + "&size=" + size;
			fetchJSON(url, {}, "get", function(data) {
				if (data.status === 0) {
					if (tableFirstLoad) {
						tableFirstLoad = false;
						laypage.render({
							curr: page + 1,
							elem: "pagination",
							count: data.data.total,
							layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
							jump: function(obj, first) {
								if (first) return;
								currentPage = obj.curr - 1;
								currentSize = obj.limit;
								loadMajorList(currentPage, currentSize);
							}
						});
					}
					tableOption.data = data.data;
					table.render(tableOption);
				} else {
					showMsg(data.msg, 2, 2000);
				}
			});
		}

		loadMajorList();
		// 监听表内工具条
		table.on("tool(majorList)", function(obj) {
			var data = obj.data;
			if (obj.event === "edit") {
				// 打开编辑框 进行详细编辑
				x_admin_show(
					"编辑",
					encodeURI(
						"../admin/major-edit.html?id=" + data.id + "&major=" + data.major + "&mark=" + data.mark
					),
					470,
					260,
					function() {
						loadMajorList(currentPage, currentSize);
					}
				);
			} else if (obj.event === "delete") {
				// 删除
				var ids = [];
				ids.push(data.id);
				layer.confirm("确认要删除吗？", function() {
					fetchJSON("api/major/delete", {
						ids: ids
					}, "post", function(data) {
						if (data.status === 0) {
							showMsg("已删除!", 1, 2000);
							tableFirstLoad = true;
							loadMajorList(currentPage, currentSize);
						} else {
							showMsg(data.msg, 2, 2000);
						}
					});
				});
			}
		});
		// 批量删除
		$("#batchDelete").on("click", function(e) {
			e.preventDefault();
			var checkedData = table.checkStatus("majorList").data;
			if (checkedData.length === 0) {
				showMsg("未选择需要删除的日志", 2, 2000);
				return;
			}
			layer.confirm("确认要删除吗？", function() {
				var ids = [];
				for (var i = 0; i < checkedData.length; i++) {
					ids.push(checkedData[i].id);
				}

				fetchJSON("api/major/delete", {
					ids: ids
				}, "post", function(data) {
					if (data.status === 0) {
						showMsg("已删除!");
						tableFirstLoad = true;
						loadMajorList(currentPage, currentSize);
					} else {
						showMsg(data.msg, 2, 2000);
					}
				});
			});
		});
		// 新建用户
		$("#addmajor").on("click", function(e) {
			e.preventDefault();
			tableFirstLoad = true;
			x_admin_show("增加", "../admin/major-edit.html?id=0&mark=&major=", 470, 260, function() {
				loadMajorList(currentPage, currentSize);
			});
		});

	});
});
