$(function() {
    var defaultPage = 0;
    var defaultSize = 10;
    var currentPage = defaultPage;
    var currentSize = defaultSize;
    var tableFirstLoad = true;

    layui.use(["form", "table", "laypage", "layer"], function() {
        var table = layui.table;
        var laypage = layui.laypage;
        var layer = layui.layer;

        function loadFuncList(page, size) {
            if (page === null || page === undefined) page = defaultPage;
            if (size === null || size === undefined) size = defaultSize;

            var tableOption = {
                elem: document.getElementById('funcList'),
                height: "full-81",
                limit: size,
                cols: [
                    [{
                            type: "checkbox"
                        },
                        {
                            field: "rightsName",
                            title: "功能名",
                            align: "center"
                        },
                        {
                            field: "rightsPath",
                            title: "地址",
                            align: "center"
                        },
                        {
                            field: "remark",
                            title: "描述",
                            align: "center"
                        },
                        {
                            field: "isHide",
                            title: "启用状态",
                            align: "center",
                            templet: function(d) {
                                return d.isHide === 1 ? "隐藏" : "显示"
                            }
                        },
                        {
                            fixed: "right",
                            title: "操作",
                            toolbar: "#operationToolbar",
                            width: 200,
                            align: "center"
                        }
                    ]
                ]
            };

            var url = "api/rights/listpage?page=" + (page + 1) + "&size=" + size;
            fetchJSON(url, {}, "get", function(data) {
                if (data.status === 0) {
                    if (tableFirstLoad) {
                        tableFirstLoad = false;
                        laypage.render({
                            curr: page + 1,
                            elem: "pagination",
                            count: data.data.total,
                            layout: ["count", "prev", "page", "next", "limit", "refresh", "skip"],
                            jump: function(obj, first) {
                                if (first) return;
                                currentPage = obj.curr - 1;
                                currentSize = obj.limit;
                                loadFuncList(currentPage, currentSize);
                            }
                        });
                    }
                    tableOption.data = data.data.list;
                    table.render(tableOption);
                } else {
                    showMsg(data.msg, 2, 2000);
                }
            });
        }

        loadFuncList();

        // 监听表内工具条
        table.on("tool(funcList)", function(obj) {
            var data = obj.data;
            if (obj.event === "edit") {
                // 打开编辑框 进行详细编辑
                x_admin_show(
                    "编辑权限",
                    encodeURI(
                        "../admin/rights-edit.html?id=" + data.id + "&rightsName=" + data.rightsName + "&rightsPath=" + data.rightsPath +
                        "&isHide=" + data.isHide + "&remark=" + data.remark
                    ),
                    400,
                    450,
                    function() {
                        loadFuncList(currentPage, currentSize);
                    }
                );
            }
        });

        // 新建用户
        $("#addRights").on("click", function(e) {
            e.preventDefault();
            tableFirstLoad = true;
            x_admin_show("添加权限", "../admin/rights-edit.html?id=0&rightsName=&rightsPath=&isHide=&remark=", 480, 300,
                function() {
                    loadFuncList(currentPage, currentSize);
                });
        });

        // 批量删除
        $("#batchDelete").on("click", function(e) {
            e.preventDefault();
            var checkedData = table.checkStatus("funcList").data;
            if (checkedData.length === 0) {
                showMsg("未选择需要删除的日志", 2, 2000);
                return;
            }
            layer.confirm("确认要删除吗？", function() {
                var ids = [];
                for (var i = 0; i < checkedData.length; i++) {
                    ids.push(checkedData[i].id);
                }

                fetchJSON("api/rights/delete", {
                    ids: ids
                }, "post", function(data) {
                    if (data.status === 0) {
                        showMsg("已删除!");
                        tableFirstLoad = true;
                        loadFuncList(currentPage, currentSize);
                    } else {
                        showMsg(data.msg, 2, 2000);
                    }
                });
            });
        });

    });
});