var aircraft_type = "";
var aircraft_id = '';
var systemId = 0;
var systemName = '';
$(function() {
    var params = window.location.href.split("?");
    if (params.length > 1) {
        values = params[1].split("&");
        if (values.length > 2) {
            systemId = values[0].replace("id=", "");
            if (systemId !== "0") {
                aircraft_type = decodeURI(values[1].replace("aircraft_type=", ""));
                systemName = decodeURI(values[2].replace("device_name=", ""));
                // funcDes = decodeURI(values[3].replace("device_describe=", ""));

            }
        }
    }

    $("#aircraft_name").val(aircraft_type);
    $("#device_name").val(systemName);

    layui.use(["form", "layer", "laydate"], function() {
        $ = layui.jquery;
        var form = layui.form,
            layer = layui.layer;
        var laydate = layui.laydate;
        //监听提交

        form.on("switch(hide)", function(data) {
            isHide = data.elem.checked ? 1 : 0;
        });
		form.on("select", function(data) {
			if (data.elem.id === "aircraft_name") {
				aircraft_id = data.elem[data.elem.selectedIndex].value;
				aircraft_type = data.elem[data.elem.selectedIndex].text;
			}
		})
        form.on("submit(save)", function(data) {
            if ($("#aircraft_name").val().trim() === "") {
                showMsg("机型不能为空", 2);
                $("#aircraft_type").focus();
                return false;
            }
			if ($("#device_name").val().trim() === "") {
			    showMsg("系统不能为空", 2);
			    $("#device_name").focus();
			    return false;
			}

            var func = data.field;
            func.id = systemId;
			func.aircraft_type = aircraft_type;
			func.aircraft_id =aircraft_id

            let url = "api/device/edit";
            fetchJSON(url, func, "post", function(data) {
                if (data.status === 0) {
                    var index = parent.layer.getFrameIndex(window.name);
                    showMsg("编辑成功", 1, 2000);
                    parent.layer.close(index);
                } else {
                    showMsg(data.msg, 2);
                }
            });
            return false;
        });
		
		function getAirType() {
			fetchJSON("api/aircraft/listAll", {}, "get", function(bet) {
				if (bet.status === 0) {
					$("#aircraft_name").empty();
					$("#aircraft_name").append($("<option>", {
						value: -1,
						text: "请选择机型"
					}));
					for (var i = 0; i < bet.data.length; i++) {
						if (bet.data[i].aircraft_type === aircraft_type) {
							$("#aircraft_name").append(
								$("<option>", {
									value: bet.data[i].id,
									text: bet.data[i].aircraft_type,
									selected: true
								})
							);
		
						} else {
							$("#aircraft_name").append(
								$("<option>", {
									value: bet.data[i].id,
									text: bet.data[i].aircraft_type
								})
							);
						}
					}
					layui.use("form", function() {
						layui.form.render('select', 'departmentFilter');
					});
		
				} else {
					showMsg(bet.msg, 2);
				}
			});
		
		};
        getAirType()
		
		
    });
});